using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.ViewInterface;

namespace SCFiler2.ListViewControl {
	public class EasySelectListViewController : ListViewController {
		public EasySelectListViewController(FileView parentView, VirtualListView targetListView) 
			: base(parentView, targetListView) {
		}

		//ListView̃ACe2ȏ゠邩ǂiEɈړł邩ǂjŎg
		static private Dictionary<Keys, string> exchangeListAtDetailView = new Dictionary<Keys, string>();
		static private Dictionary<Keys, string> exchangeListAtThumbnailView = new Dictionary<Keys, string>();
		Dictionary<Keys, string> exchangeList;

		/// <summary>
		/// X^eBbNCjVCU
		/// </summary>
		static EasySelectListViewController() {
			exchangeListAtDetailView.Add(Keys.Up, "^{UP}");
			exchangeListAtDetailView.Add(Keys.Down, "^{DOWN}");
			exchangeListAtDetailView.Add(Keys.PageUp, "^{PGUP}");
			exchangeListAtDetailView.Add(Keys.PageDown, "^{PGDN}");
			exchangeListAtDetailView.Add(Keys.Home, "^{HOME}");
			exchangeListAtDetailView.Add(Keys.End, "^{END}");
			exchangeListAtDetailView.Add(Keys.Space, "^( {DOWN})");

			exchangeListAtThumbnailView.Add(Keys.Up, "^{UP}");
			exchangeListAtThumbnailView.Add(Keys.Down, "^{DOWN}");
			exchangeListAtThumbnailView.Add(Keys.Right, "^{RIGHT}");
			exchangeListAtThumbnailView.Add(Keys.Left, "^{LEFT}");
			exchangeListAtThumbnailView.Add(Keys.PageUp, "^{PGUP}");
			exchangeListAtThumbnailView.Add(Keys.PageDown, "^{PGDN}");
			exchangeListAtThumbnailView.Add(Keys.Home, "^{HOME}");
			exchangeListAtThumbnailView.Add(Keys.End, "^{END}");
			exchangeListAtThumbnailView.Add(Keys.Space, "^ ");
		}

		public override void Initialize() {
			SCFiler2System.ShowTempMessage("Xy[XL[őI[h");
			//ftHgŎĂItemSearcher
			allItemSearcher.Add(ItemSearcher.SearchType.Basic, new BasicItemSearcher(this, targetListView));
			allItemSearcher.Add(ItemSearcher.SearchType.Prefix, new PrefixItemSearcher(this, targetListView));

			//݂̃ACeIԂɂĈɈړ
			if (this.parentView.ViewMode == ViewMode.ThumbnailMode) {
				if (!this.targetListView.FocusedItem.Selected) {
					this.targetListView.FocusedItem.Selected = true;
				}
			} else {
				if (this.targetListView.FocusedItem.Selected) {
					SendKeys.Send(exchangeListAtDetailView[Keys.Down]);
				} else {
					SendKeys.Send(exchangeListAtDetailView[Keys.Space]);
				}
			}
			
		}
		public override void Terminate() {
			//SĂsearcherI点
			foreach (ItemSearcher searcher in allItemSearcher.Values) {
				searcher.Terminate();
			}
			allItemSearcher.Clear();

			//r[̑IԂ
			targetListView.SelectedItems.Clear();
			if (targetListView.FocusedItem != null) {
				targetListView.FocusedItem.Selected = true;
			} else if (targetListView.Items.Count > 0) {
				targetListView.Items[0].Selected = true;
			}

			SCFiler2System.ShowTempMessage("Xy[XL[őI[hI");
		}

		public override SelectMode Type {
			get { return SelectMode.Easy; }
		}

		override public Result KeyProcessingBeforeKeyCommand(KeyEventArgs keyEvent) {
			this.exchangeList = (this.parentView.ViewMode == ViewMode.ThumbnailMode) ? exchangeListAtThumbnailView : exchangeListAtDetailView;

			if (this.exchangeList.ContainsKey(keyEvent.KeyCode) && keyEvent.Control) {
				return Result.DelegateToOriginalControl;
			}

			//incremental search, Migemo
			ItemSearcher searcher = null;
			if (allItemSearcher.ContainsKey(ItemSearcher.SearchType.Incremental)) {
				searcher = allItemSearcher[ItemSearcher.SearchType.Incremental];
			} else if (allItemSearcher.ContainsKey(ItemSearcher.SearchType.Migemo)) {
				searcher = allItemSearcher[ItemSearcher.SearchType.Migemo];
			}

			if (this.targetListView.Items.Count != 0 && searcher != null) {
				ItemSearcher.Result result = searcher.KeyDown(keyEvent);
				switch (result) {
					case ItemSearcher.Result.ItemFound:
						base.OnlyFocusMove(searcher.FoundItem);
						return Result.EventHandled;
					case ItemSearcher.Result.ItemNotFound:
						return Result.EventHandled;
					case ItemSearcher.Result.ExitCurrentSearchMode:
						base.RemoveSearchMode(searcher.Type);
						return Result.EventHandled;
				}
			}

			//㉺EL[Ȃǂ̓L[CxgϊĔsiRg[IWi̐𐶂ăL[̂ݓւj
			if (this.targetListView.Items.Count != 0 && !keyEvent.Shift && !keyEvent.Control && !keyEvent.Alt && exchangeList.ContainsKey(keyEvent.KeyCode)) {
				SendKeys.Send(exchangeList[keyEvent.KeyCode]);
				return Result.EventHandled;
			}


			//EscapeꂽIiNormalControllerɖ߂j
			if (keyEvent.KeyCode == Keys.Escape && !keyEvent.Control && !keyEvent.Alt && !keyEvent.Shift) {
				return Result.ExitCurrentController;
			}

			//ǂɂȂƂ͏ȂƂɂ
			return Result.EventNotHandled;
		}

		override public Result KeyProcessingAfterKeyCommand(KeyEventArgs keyEvent) {
			//ACeO͉̎Ȃ
			if (this.targetListView.Items.Count == 0) {
				return Result.EventNotHandled;
			}

			//T[`
			if (allItemSearcher.ContainsKey(ItemSearcher.SearchType.Prefix)) {
				ItemSearcher searcher = allItemSearcher[ItemSearcher.SearchType.Prefix];
				ItemSearcher.Result result = searcher.KeyDown(keyEvent);
				switch (result) {
					case ItemSearcher.Result.ItemFound:
						SimpleMove(searcher.FoundItem);
						return Result.EventHandled;
					case ItemSearcher.Result.ItemNotFound:
						return Result.EventHandled;
				}
			}

			return Result.EventNotHandled;
		}

	}

}
