using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using SCFiler2.FileSystem;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;
using SCFiler2.PluginInterface;

namespace SCFiler2 {
	/// <summary>
	/// ̊Oc[\NX
	/// </summary>
	public class ExternalTool {

		/// <summary>
		/// Oc[ɂӂ̒ʂԍ
		/// </summary>
		private int index;

		public int Index {
			get { return index; }
		}

		private string toolTitle;

		/// <summary>
		/// ̊Oc[ɂo^^Cg
		/// </summary>
		public string Title {
			set { this.toolTitle = value; }
			get { return this.toolTitle; }
		}

		private string toolPathStr;

		/// <summary>
		/// c[exet@C̃pX
		/// </summary>
		public string Path {
			set { this.toolPathStr = value; }
			get { return this.toolPathStr; }
		}


		private string toolArgumentStr;

		/// <summary>
		/// s̈
		/// </summary>
		public string Argument {
			set { this.toolArgumentStr = value; }
			get { return this.toolArgumentStr; }
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="index">̃c[ɂʂԍ</param>
		/// <param name="toolTitle">^Cgij[Ȃǂɕ\j</param>
		/// <param name="toolPath">Oc[̃tpX</param>
		/// <param name="argumentString">Oc[ɓnR}hC</param>
		public ExternalTool(int index, string toolTitle, string toolPath, string argumentString) {
			this.index = index;
			this.toolTitle = toolTitle;
			this.toolPathStr = toolPath;
			this.toolArgumentStr = argumentString;
		}

		/// <summary>
		/// r[őI𒆂̃ACeOc[Ŏs
		/// </summary>
		public void Execute() {
			IFilerItem targetItem = null;
			//r[̑It@Ct@C擾Ďs
			if (this.toolArgumentStr.IndexOf(@"%%%SELECTED_FILE%%%") >= 0) {
				if (ViewInterfaces.LastFocusedFileView.SelectedFilerItems.Count == 0) {
					SCFiler2System.ShowTempMessage("t@CIĂ܂");
					return;
				}
				targetItem = ViewInterfaces.LastFocusedFileView.SelectedFilerItems[0];
			}
			this.Execute(targetItem);
		}

		/// <summary>
		/// Oc[Ŏs
		/// </summary>
		/// <param name="target"></param>
		public void Execute(IFilerItem target) {
			//o^ꂽst@CsɂȂG[ԂďI
			if (!System.IO.File.Exists(this.toolPathStr)) {
				SCFiler2System.ShowHistoryMessage("[error]Oc[w" + toolTitle + "xo^ꂽpXɌ܂");
				return;
			}
			ProcessStartInfo startInfo = new ProcessStartInfo();
			StringBuilder builder = new StringBuilder(this.toolArgumentStr);

			if (target != null) {
				startInfo.WorkingDirectory = target.Path;
				builder.Replace(@"%%%SELECTED_FILE%%%", "\"" + target.FullName + "\"");//Ƃ肠PΉ
				builder.Replace(@"%%%CURRENT_PATH%%%", "\"" + target.Path + "\"");
			} else {
				startInfo.WorkingDirectory = ViewInterfaces.LastFocusedFileView.CurrentPath;
				builder.Replace(@"%%%SELECTED_FILE%%%", "");
				builder.Replace(@"%%%CURRENT_PATH%%%", "\"" + ViewInterfaces.LastFocusedFileView.CurrentPath + "\"");
			}
			startInfo.Arguments = builder.ToString();

			startInfo.FileName = toolPathStr;
			Process.Start(startInfo);

			//sꂽACe͗r[̍ŐVɂ
			if (target != null) {
				foreach (HistoryManager manager in MainForm.Instance.AllHistoryManager) {
					manager.NotifyItemExecuted(target);
				}
			}
		}
	}
}
