using System;
using System.Collections.Generic;
using System.Text;

namespace SCFiler2.FileSystem {
	public class FolderTrace {
		private List<String> traceList = new List<string>();
		private int currentIndex;
		private const int CountMax = 30;

		public bool IsHaveNextFolder {
			get {
				if (this.traceList.Count -1 <= currentIndex) {
					return false;
				} else {
					return true;
				}
			}
		}

		public bool IsHavePreviousFolder {
			get {
				if (currentIndex > 0) {
					return true;
				} else {
					return false;
				}
			}
		}

		/// <summary>
		/// tH_L^
		/// </summary>
		/// <param name="fullname">L^tH_FullName</param>
		public void Record(String fullname) {
			if (this.traceList.Count == 0) {
				this.traceList.Add(fullname);
				currentIndex=0;
			} else if (this.traceList[currentIndex] == fullname) {
				//Ȃ
				//ƂPreviousFolder()Ŗ߂Record()ĂяoꂽȂǂɂ
			} else if (this.IsHaveNextFolder && fullname == this.traceList[currentIndex + 1]) {
				//L^Ă鎟̃tH_ɈړAindexύX邾
				currentIndex++;
			} else {
				//VtH_Ɉړ́Ã݂ACe͑S폜
				this.traceList.RemoveRange(currentIndex + 1, this.traceList.Count - currentIndex - 1);

				//ǉ
				this.traceList.Add(fullname);
				currentIndex++;

				//L^̍ől𒴂ÂL^
				if (this.traceList.Count >= CountMax) {
					this.traceList.RemoveAt(0);
					currentIndex--;
				}
			}
		}

		/// <summary>
		/// ̃tH_ԂBOIsHaveNextFolder()Œׂ邱
		/// ŶȂnullԂ
		/// </summary>
		/// <returns>̃tH_̂FullName</returns>
		public String NextFolder() {
			if (this.IsHaveNextFolder) {
				currentIndex++;
				return this.traceList[currentIndex];
			} else {
				return null;
			}
		}

		/// <summary>
		/// ÕtH_ԂBOIsHavePreviousFolder()Œׂ邱
		/// ŶȂnullԂ
		/// </summary>
		/// <returns>ÕtH_FullName</returns>
		public String PreviousFolder() {
			if (this.IsHavePreviousFolder) {
				currentIndex--;
				return this.traceList[currentIndex];
			} else {
				return null;
			}
		}

	}
}
