﻿using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.ViewInterface;

namespace SCFiler2.Operation {
	public class GoToSameFolderAsAnotherView : Action {
		public override string DisplayString {
			get { return "もう一方のビューと同じパスに移動"; }
		}

		public override ActionType Type {
			get { return ActionType.Move; }
		}

		public override void Execute() {
			if (MainForm.Instance.FocusedViewType == MainForm.EFocusedViewType.FileView) {
				IFileView activeView = ViewInterfaces.LastFocusedFileView;
				IFileView inactiveView = ViewInterfaces.OtherOfLastFocusedFileView;

				activeView.ChangePath(inactiveView.CurrentPath);
				activeView.SelectMode = SelectMode.Normal;
			} else {
				//何もしない
			}
		}
	}
}
