using System;
using System.Collections.Generic;
using System.Text;

namespace SCFiler2.FileSystem {
	/// <summary>
	/// JobǗA܂ĂjobsĂNX
	/// VOg
	/// </summary>
	public class JobManager {
		static private JobManager instance = new JobManager();
		static public JobManager Instance {
			get { return instance; }
		}

		private Queue<Job> jobList = new Queue<Job>();
		private Job currentJob = null;

		private JobManager() {
		}

		/// <summary>
		/// ݎs̃WũXbhI܂ő҂
		/// </summary>
		public void WaitCurrentJobThreadEnd() {
			if (currentJob != null) {
				currentJob.ThreadJoin();
			}
		}

		/// <summary>
		/// ݎs̃WuIƂ̏
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void CurrentJobFinished(object sender, EventArgs e) {
			lock (this) {
				if (jobList.Count > 0) {
					currentJob = jobList.Dequeue();
					MainForm.Instance.PrintToJobInfoArea("҂Job:" + jobList.Count.ToString());
					currentJob.Execute();
				} else {
					currentJob = null;
					MainForm.Instance.PrintToJobInfoArea("");
				}
			}
		}

		/// <summary>
		/// s̃WuLZꂽƂ̏
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void CurrentJobCanceled(object sender, EventArgs e) {
			lock (this) {
				if (jobList.Count > 0) {
					currentJob = jobList.Dequeue();
					MainForm.Instance.PrintToJobInfoArea("҂Job:" + jobList.Count.ToString());
					currentJob.Execute();
				} else {
					currentJob = null;
					MainForm.Instance.PrintToJobInfoArea("");
				}
			}
		}

		/// <summary>
		/// ǗL[ɃWuǉ
		/// </summary>
		/// <param name="job"></param>
		public void AddJob(Job job) {
			lock (this) {
				job.Finish += this.CurrentJobFinished;
				if (this.currentJob == null) {
					this.currentJob = job;
					job.Execute();
				} else {
					jobList.Enqueue(job);
					SCFiler2System.ShowHistoryMessage("Wuǉ܂");
				}
				MainForm.Instance.PrintToJobInfoArea("҂Job:" + jobList.Count.ToString());
			}

		}

		/// <summary>
		/// Wu𒼂Ɏs
		/// </summary>
		/// <param name="job"></param>
		public void ExecuteJobNow(Job job) {
			lock (this) {
				if (this.currentJob != null) {
					throw new Exception("VXȅԂsł"); //TODO ƂExceptionɕύX
				}
			}
			job.Finish += this.CurrentJobFinished;
			this.currentJob = job;
			this.currentJob.Execute();
		}

		/// <summary>
		/// ݎs̃Wu邩ǂ
		/// </summary>
		public bool HasActiveJob {
			get {
				lock (this) {
					if (this.currentJob == null || this.jobList.Count > 0) {
						return false;
					} else {
						return true;
					}
				}
			}
		}

		/// <summary>
		/// ݎs̃Wu܂߁Ao^ς݂̑SẴWuLZ
		/// </summary>
		public void CancelAllJob() {
			lock (this) {
				this.jobList.Clear();
				this.currentJob.Cancel();
			}
		}
	}
}
