﻿using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.ItemInterface;

namespace SCFiler2.FileSystem {
	public class JumpFolder : IJumpFolder {
		/// <summary>
		/// ジャンプフォルダが指しているフォルダ
		/// </summary>
		Folder folder;
		/// <summary>
		/// ジャンプフォルダにつける名前
		/// </summary>
		string title; 

		/// <summary>
		/// ジャンプフォルダにつける名前
		/// </summary>
		public string Title {
			get { return title; }
		}
		/// <summary>
		/// ジャンプフォルダが指しているフォルダ
		/// </summary>
		public IFolder Folder {
			get { return folder; }
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="jumpfolderTitle">ジャンプフォルダにつけるタイトル</param>
		/// <param name="folderPath">ジャンプフォルダに設定するフォルダのパス</param>
		public JumpFolder(string jumpfolderTitle, string folderPath) {
			title = jumpfolderTitle;
			folder = new Folder(folderPath);
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="jumpfolderTitle">ジャンプフォルダにつけるタイトル</param>
		/// <param name="folder">ジャンプフォルダに設定するフォルダ</param>
		public JumpFolder(string jumpfolderTitle, Folder folder) {
			title = jumpfolderTitle;
			this.folder = folder;
		}
	}
}
