using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.CommonDialog;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.ViewInterface;
using SCFiler2.ItemInterface;

namespace SCFiler2.Operation {
	class MoveDialog : Action {
		public override string DisplayString {
			get { return "ړ(move)Iňړ"; }
		}

		public override ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void Execute() {
			if (ViewInterfaces.CurrentItemView.Type != ViewType.FileView) {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_IN_THIS_VIEW);
				return;
			}

			IFileView activeView = ViewInterfaces.LastFocusedFileView;
			IFileView inactiveView = ViewInterfaces.OtherOfLastFocusedFileView;

			if (activeView.CurrentPath == "") {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_IS_NOT_VALID_FOR_DRIVE_CATALOGUE);
				return;
			}

			if (activeView.SelectedFilerItems.Count == 0) {
				SCFiler2System.ShowTempMessage("t@CIĂ܂");
				return;
			}

			OperationTargetDialog targetDialog = new OperationTargetDialog();
			targetDialog.DialogTitle = "ړI";
			DialogResult targetDialogResult = targetDialog.ShowDialog();

			if (targetDialogResult == DialogResult.OK) {
				OperationTargetDialog.Target target = targetDialog.SelectedTarget;
				switch (target) {
					case OperationTargetDialog.Target.AnotherView:

						if (inactiveView.CurrentPath == "") {
							SCFiler2System.ShowTempMessage("΂̃r[hCuꗗ\Ă̂ŃR}hsł܂");
							return;
						}
						MoveJob job;
						try {
							job = new MoveJob(new Folder(inactiveView.CurrentPath), activeView.SelectedFilerItems);
						} catch (InvalidPreConditionJobException ex) {
							SCFiler2System.ShowDialogMessage(ex.Message);
							return;
						}

						if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
							JobManager.Instance.AddJob(job);
						} else {
							JobManager.Instance.ExecuteJobNow(job);
						}
						ViewInterfaces.CheckUpdateAllView();
						activeView.UpdateView();
						activeView.SelectMode = SelectMode.Normal;
						inactiveView.UpdateView();
						inactiveView.SelectMode = SelectMode.Normal;
						inactiveView.ViewMode = ViewMode.Normal;
						break;
						
					case OperationTargetDialog.Target.Clipboard:
						ClipboardManager.SendToClipboard(ClipboardManager.EffectType.Cut, activeView.SelectedFilerItems);
						SCFiler2System.ShowTempMessage("IACeNbv{[hɐ؂܂");
						ViewInterfaces.CheckUpdateAllView();
						activeView.SelectMode = SelectMode.Normal;
						break;
					case OperationTargetDialog.Target.JumpFolder:
						JumpFolderDialog jumpDialog = new JumpFolderDialog();
						DialogResult jumpDialogResult = jumpDialog.ShowDialog();
						if (jumpDialogResult == DialogResult.OK) {
							MoveJob moveJob;
							try {
								moveJob = new MoveJob(new Folder(jumpDialog.SelectedJumpFolder.Folder.FullName), activeView.SelectedFilerItems);
							} catch (InvalidPreConditionJobException ex) {
								SCFiler2System.ShowDialogMessage(ex.Message);
								return;
							}

							if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
								JobManager.Instance.AddJob(moveJob);
							} else {
								JobManager.Instance.ExecuteJobNow(moveJob);
							}
							MainForm.Instance.CheckUpdateAllView();
							activeView.SelectMode = SelectMode.Normal;
						} else {
							SCFiler2System.ShowTempMessage(Messages.COMMAND_CANCELED);
							return;
						}
						break;
					case OperationTargetDialog.Target.RightUnder:
						List<IFilerItem> directoryList = new List<IFilerItem>();
						System.IO.DirectoryInfo info = new System.IO.DirectoryInfo(activeView.CurrentPath);
						System.IO.DirectoryInfo[] directories = info.GetDirectories();
						foreach (System.IO.DirectoryInfo item in directories) {
							directoryList.Add(new Folder(item.FullName));
						}

						FilerItemSelectDialog selectDialog = new FilerItemSelectDialog();
						selectDialog.setItems(directoryList);
						selectDialog.DialogTitle = "ړIĂ";
						DialogResult selectDialogResult = selectDialog.ShowDialog();
						if (selectDialogResult == DialogResult.OK) {
							foreach (FilerItem item in activeView.SelectedFilerItems) {
								if (item.FullName == selectDialog.SelectedItem.FullName) {
									SCFiler2System.ShowDialogMessage(item.FullName + "IꂽtH_Ɉړ邱Ƃ͂ł܂");
									return;
								}
							}

							MoveJob moveJob2;
							try {
								moveJob2 = new MoveJob(new Folder(selectDialog.SelectedItem.FullName), activeView.SelectedFilerItems);
							} catch (InvalidPreConditionJobException ex) {
								SCFiler2System.ShowDialogMessage(ex.Message);
								return;
							}

							if (SCFiler2System.Instance.Option.Application.IsAllowOperationWhileCopyMoveDel) {
								JobManager.Instance.AddJob(moveJob2);
							} else {
								JobManager.Instance.ExecuteJobNow(moveJob2);
							}
							activeView.SelectMode = SelectMode.Normal;
							MainForm.Instance.CheckUpdateAllView();
						} else {
							SCFiler2System.ShowTempMessage(Messages.COMMAND_CANCELED);
							return;
						}
						break;
				}
			} else {
				SCFiler2System.ShowTempMessage(Messages.COMMAND_CANCELED);
				return;
			}
		}
	}
}
