using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.Util;
using SCFiler2.ViewInterface;

namespace SCFiler2.ListViewControl {
	/// <summary>
	/// L[̃Xgr[̃tH[JXƑIԂRg[NX
	/// </summary>
	public class NormalListViewController : ListViewController {

		public override void Initialize() {
			allItemSearcher.Add(ItemSearcher.SearchType.Basic, new BasicItemSearcher(this, targetListView));
			allItemSearcher.Add(ItemSearcher.SearchType.Prefix, new PrefixItemSearcher(this, targetListView));
		}

		public override void Terminate() {
			//SĂSearcherI
			foreach (ItemSearcher searcher in allItemSearcher.Values) {
				searcher.Terminate();
			}
			allItemSearcher.Clear();
		}

		public override SelectMode Type {
			get { return SelectMode.Normal; }
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="targetListView">Rg[^[QbgNX</param>
		public NormalListViewController(FileView parentView, VirtualListView targetListView) 
			: base(parentView, targetListView) {
			
		}

		/// <summary>
		/// L[R}hD悵ďꍇ̃Cxg֐
		/// trueԂƃL[R}hɏnȂinȂ悤ɂ邱Ƃłj
		/// </summary>
		/// <param name="keyEvent">L[Cxg</param>
		/// <returns>L[Cxgς݂ɂĂ悯true</returns>
		override public Result KeyProcessingBeforeKeyCommand(KeyEventArgs keyEvent) {
			//ACeO͉̎Ȃ
			if (this.targetListView.Items.Count == 0) {
				return Result.EventNotHandled;
			}

			if (this.parentView.ViewMode == ViewMode.ThumbnailMode && (keyEvent.KeyCode == Keys.Left || keyEvent.KeyCode == Keys.Right)
				&& !keyEvent.Shift && !keyEvent.Control && !keyEvent.Alt) {
				return Result.DelegateToOriginalControl;
			}

			//incremental search, Migemo
			ItemSearcher searcher = null;
			if (allItemSearcher.ContainsKey(ItemSearcher.SearchType.Incremental)) {
				searcher = allItemSearcher[ItemSearcher.SearchType.Incremental];
			} else if (allItemSearcher.ContainsKey(ItemSearcher.SearchType.Migemo)) {
				searcher = allItemSearcher[ItemSearcher.SearchType.Migemo];
			}

			if (searcher != null) {
				ItemSearcher.Result result = searcher.KeyDown(keyEvent);
				switch (result) {
					case ItemSearcher.Result.ItemFound:
						SimpleMove(searcher.FoundItem);
						return Result.EventHandled;
					case ItemSearcher.Result.ItemNotFound:
						return Result.EventHandled;
					case ItemSearcher.Result.ExitCurrentSearchMode:
						searcher.Terminate();
						RemoveSearchMode(searcher.Type);
						return Result.EventHandled;
				}
			}

			return Result.EventNotHandled;
		}

		/// <summary>
		/// L[R}hŏꂽꍇɏL[
		/// </summary>
		/// <param name="keyEvent">L[Cxg</param>
		/// <returns>L[Cxgς݂łtrue</returns>
		override public Result KeyProcessingAfterKeyCommand(KeyEventArgs keyEvent) {
			//ACeO͉̎Ȃ
			if (this.targetListView.Items.Count == 0) {
				return Result.EventNotHandled;
			}

			//T[`
			if (allItemSearcher.ContainsKey(ItemSearcher.SearchType.Prefix)) {
			    ItemSearcher searcher = allItemSearcher[ItemSearcher.SearchType.Prefix];
			    ItemSearcher.Result result = searcher.KeyDown(keyEvent);
			    switch (result) {
			        case ItemSearcher.Result.ItemFound:
			            SimpleMove(searcher.FoundItem);
			            return Result.EventHandled;
			        case ItemSearcher.Result.ItemNotFound:
			            return Result.EventHandled;
			    }
			}

			return Result.EventNotHandled;
		}


	}
}
