using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.Operation;
using SCFiler2.Plugin;
using SCFiler2.PluginInterface;

namespace SCFiler2 {
	public partial class OptionDialog : Form {
		private ExternalToolAssignControl[] externalToolCtrlList = new ExternalToolAssignControl[ExternalToolManager.MaxToolNum];

		public OptionDialog() {
			InitializeComponent();
		}

		/// <summary>
		/// tH[ɂĂĩ^uł͂ȂƂӖjLZ{^̃NbNCxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cancelButton_Click(object sender, EventArgs e) {
			Close();
		}

		/// <summary>
		/// tH[ɂĂĩ^uł͂ȂƂӖjOK{^̃NbNCxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void okButton_Click(object sender, EventArgs e) {
			MainForm mainForm = MainForm.Instance;
			SCFiler2System system = SCFiler2System.Instance;

			//ʃ^u
			system.Option.FileView.excludeExtensions = Util.StringUtil.GetListFromConnectedString(excludeExtension.Text, new char[]{';'});
			system.Option.Application.IsIgnoreFloppyCheck = isIgnoreFloppyCheckCheckBox.Checked;
			system.Option.Application.IsMinimizeFormWhenAppStart = isMinimizeWhenAppStartCheckBox.Checked;
			system.Option.Application.IsLoadMigemoWhenAppStart = isLoadMigemoWhenAppStartCheckBox.Checked;
			system.Option.Application.IsUseShellContextMenu = isUseShellContextMenuCheckbox.Checked;
			system.Option.Application.IsAllowOperationWhileCopyMoveDel = isAllowOperationWhileCopyMoveDelCheckBox.Checked;

			//L[蓖āiQj^u
			system.Option.KeyCommand.ChangeDriveByNumKey = changeDriveByNumkeyCheckbox.Checked;

			//\^u
			system.Option.FileView.IsHideHiddenFile = this.IsHideHiddenFileCheckBox.Checked;
			system.Option.FileView.IsHideSystemFile = this.IsHideSystemFileCheckbox.Checked;
			system.Option.FileView.IsDisplayDriveToolbar = !this.IsHideDriveToolbarCheckbox.Checked;
			system.Option.FileView.IsDisplayHistoryView = !this.IsHideHistoryViewCheckbox.Checked;
			if (FileIconAllDisplayRadioBUtton.Checked) {
				system.Option.FileView.IconDisplay = SCFiler2System.OptionClass.FileViewOption.FileIconDisp.All;
			} else if (FileIconOnlyExeDisplayRadioButton.Checked) {
				system.Option.FileView.IconDisplay = SCFiler2System.OptionClass.FileViewOption.FileIconDisp.ExeOnly;
			} else {
				system.Option.FileView.IconDisplay = SCFiler2System.OptionClass.FileViewOption.FileIconDisp.Nothing;
			}
			try {
				system.Option.FileView.ThumbnailWidth = Math.Min(Math.Max(80, int.Parse(this.ThumbnailWidthTextbox.Text)), 300);
				system.Option.FileView.ThumbnailHeight = Math.Min(Math.Max(80, int.Parse(this.ThumbnailHeightTextbox.Text)), 300);
			} catch {
				//ϊɎsftHglɖ߂
				system.Option.FileView.ThumbnailWidth = 120;
				system.Option.FileView.ThumbnailHeight = 120;
			}

			//F^u
			system.Option.Color.ActiveViewTitleText = colorActiveViewTitle.ForegroundColor;
			system.Option.Color.ActiveViewTitleBack = colorActiveViewTitle.BackgroundColor;
			system.Option.Color.InactiveViewTitleText = colorInactiveViewTitle.ForegroundColor;
			system.Option.Color.InactiveViewTitleBack = colorInactiveViewTitle.BackgroundColor;
			system.Option.Color.FocusedWithoutSelectedListViewItemText = colorFocusedWithoutSelectedListViewItem.ForegroundColor;
			system.Option.Color.FocusedWithoutSelectedListViewItemBack = colorFocusedWithoutSelectedListViewItem.BackgroundColor;
			
			//^u
			mainForm.FileHistoryManager1.SetValidExtension(historyview1ValidExtensionsString.Text);
			mainForm.FileHistoryManager1.Save();
			mainForm.FileHistoryManager2.SetValidExtension(historyview2ValidExtensionsString.Text);
			mainForm.FileHistoryManager2.Save();
			system.Option.Application.IsAddItemToHistoryWhenDrag = this.IsAddItemToHistoryWhenDrag.Checked;
			try {
				int num = int.Parse(this.HistoryViewItemMax.Text.ToString());
				if (num <= 250) {
					system.Option.HistoryView.ItemMaxNum = num;
				}
			} catch {
				//Exception͉̎ȂB̒l̂܂
			}

			//Oc[^u
			for (int i = 0; i < ExternalToolManager.MaxToolNum; i++) {
				ExternalTool tool = externalToolCtrlList[i].RefrectValueToAssignedItem();
				if (tool != null) {
					ExternalToolManager.Instance.Regist(tool);
				} else {
					ExternalToolManager.Instance.Remove(i + 1);
				}
			}
			ExternalToolManager.Instance.Save();
			ExternalToolContextMenu.Instance.UpdateMenuItem();

			//JX^c[o[^u
			CustomToolbarManager.Instance.Clear();
			foreach (ListViewItem listviewItem in customToolbarList.Items) {
				CustomToolbarManager.Instance.Add((CustomToolbarItem)listviewItem.Tag);
			}
			CustomToolbarManager.Instance.Save();
			MainForm.Instance.constructMainToolbar();

			SCFiler2System.Instance.Option.Save();

			Close();
		}

		/// <summary>
		/// L[蓖āiPj^u u蓖āv{^Ƃ̃L[Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void assignButton_Click(object sender, EventArgs e) {
			string command = newKey.Text;

			Operation.Action action = KeyCommandManager.Instance.GetAssignedAction(command);
			if (action != null) {
				SCFiler2System.ShowDialogMessage("̃L[͂ł"+action.DisplayString+"Ɋ蓖ĂĂ܂");
				return;
			}
			KeyCommandManager.Instance.RegistAction((ActionManager.ActionID)actionList.SelectedItems[0].Tag, command);
			KeyCommandManager.Instance.Save();
			SCFiler2System.ShowDialogMessage("L[蓖Ă܂");
		}

		private const string allActionOptionString = "S";

		private void OptionDialog_Load(object sender, EventArgs e) {
			SCFiler2System system = SCFiler2System.Instance;

			
			//ʃ^u
			excludeExtension.Text = Util.StringUtil.GetConnectedStringFromList(system.Option.FileView.excludeExtensions, ';');
			isIgnoreFloppyCheckCheckBox.Checked = system.Option.Application.IsIgnoreFloppyCheck;
			isMinimizeWhenAppStartCheckBox.Checked = system.Option.Application.IsMinimizeFormWhenAppStart;
			isLoadMigemoWhenAppStartCheckBox.Checked = system.Option.Application.IsLoadMigemoWhenAppStart;
			isUseShellContextMenuCheckbox.Checked = system.Option.Application.IsUseShellContextMenu;
			isAllowOperationWhileCopyMoveDelCheckBox.Checked = system.Option.Application.IsAllowOperationWhileCopyMoveDel;

			//L[蓖(1)^u

			//Xgr[̊蓖āB
			actionTypeComboBox.Items.Add(allActionOptionString);
			foreach (Operation.Action.ActionType type in Enum.GetValues(typeof(Operation.Action.ActionType))) {
				actionTypeComboBox.Items.Add(Operation.Action.GetTypeString(type));
			}
			actionTypeComboBox.SelectedItem = allActionOptionString;
			
			//SẴANV̒ǉ
			actionList.Columns.Add("", 220);
			foreach (ActionManager.ActionID id in Enum.GetValues(typeof(ActionManager.ActionID))) {
				Action action = ActionManager.CreateAction(id);
				ListViewItem item = new ListViewItem(action.DisplayString);
				item.Tag = id;
				actionList.Items.Add(item);
			}


			//L[蓖āiQj^u
			changeDriveByNumkeyCheckbox.Checked = system.Option.KeyCommand.ChangeDriveByNumKey;

			//\^u
			this.IsHideHiddenFileCheckBox.Checked = system.Option.FileView.IsHideHiddenFile;
			this.IsHideSystemFileCheckbox.Checked = system.Option.FileView.IsHideSystemFile;
			this.IsHideDriveToolbarCheckbox.Checked = !system.Option.FileView.IsDisplayDriveToolbar;
			this.IsHideHistoryViewCheckbox.Checked = !system.Option.FileView.IsDisplayHistoryView;
			switch (system.Option.FileView.IconDisplay) {
				case SCFiler2System.OptionClass.FileViewOption.FileIconDisp.Nothing:
					this.FileIconNotDisplayRadioButton.Checked = true;
					break;
				case SCFiler2System.OptionClass.FileViewOption.FileIconDisp.ExeOnly:
					this.FileIconOnlyExeDisplayRadioButton.Checked = true;
					break;
				case SCFiler2System.OptionClass.FileViewOption.FileIconDisp.All:
					this.FileIconAllDisplayRadioBUtton.Checked = true;
					break;
			}
			this.ThumbnailWidthTextbox.Text = system.Option.FileView.ThumbnailWidth.ToString();
			this.ThumbnailHeightTextbox.Text = system.Option.FileView.ThumbnailHeight.ToString();

			//^u
			historyview1ValidExtensionsString.Text = MainForm.Instance.FileHistoryManager1.GetValidExtension();
			historyview2ValidExtensionsString.Text = MainForm.Instance.FileHistoryManager2.GetValidExtension();
			this.IsAddItemToHistoryWhenDrag.Checked = system.Option.Application.IsAddItemToHistoryWhenDrag;
			this.HistoryViewItemMax.Text = system.Option.HistoryView.ItemMaxNum.ToString();

			//F^u
			colorActiveViewTitle.initialize("ANeBuȃr[̃^Cg", system.Option.Color.ActiveViewTitleText, system.Option.Color.ActiveViewTitleBack);
			colorInactiveViewTitle.initialize("ANeBuȃr[̃^Cg",system.Option.Color.InactiveViewTitleText, system.Option.Color.InactiveViewTitleBack);
			colorFocusedWithoutSelectedListViewItem.initialize("ĨtH[JXACe", system.Option.Color.FocusedWithoutSelectedListViewItemText, system.Option.Color.FocusedWithoutSelectedListViewItemBack);

			//Oc[^u
			externalToolCtrlList[0] = externalToolAssignControl1;
			externalToolCtrlList[1] = externalToolAssignControl2;
			externalToolCtrlList[2] = externalToolAssignControl3;
			externalToolCtrlList[3] = externalToolAssignControl4;
			externalToolCtrlList[4] = externalToolAssignControl5;

			for (int i = 0; i < ExternalToolManager.MaxToolNum; i++) {
				externalToolCtrlList[i].initialize(i + 1, ExternalToolManager.Instance.GetItem(i+1));
			}

			//JX^c[o[^u
			for (int i = 0; i < CustomToolbarManager.Instance.Count; i++) {
				CustomToolbarItem item = CustomToolbarManager.Instance.GetItem(i);
				ListViewItem listviewItem = new ListViewItem(item.DisplayString);
				listviewItem.Tag = item;
				customToolbarList.Items.Add(listviewItem);
			}
			foreach (ActionManager.ActionID id in Enum.GetValues(typeof(ActionManager.ActionID))) {
				Action action = ActionManager.CreateAction(id);
				actionListComboBox.Items.Add(action);
			}

			//֘At^u
			this.UpdateExtensionRelationCustomizeList();

			//vOC^u
			this.UpdatePluginList();
		}

		/// <summary>
		/// ֘At^ũXgXViǂݍށj
		/// </summary>
		private void UpdateExtensionRelationCustomizeList() {
			this.ExtensionRelationCustomizeListbox.Items.Clear();
			for (int i = 0; i < ExtensionRelationCustomize.Instance.Items.Count; i++) {
				ListViewItem viewItem = new ListViewItem((i + 1).ToString());
				viewItem.SubItems.Add(ExtensionRelationCustomize.Instance.Items[i].expression.ToString());
				viewItem.SubItems.Add("Oc[" + (ExtensionRelationCustomize.Instance.Items[i].num + 1).ToString());
				viewItem.Tag = ExtensionRelationCustomize.Instance.Items[i];
				ExtensionRelationCustomizeListbox.Items.Add(viewItem);
			}
		}

		/// <summary>
		/// vOC^ũXgXViǂݍށj
		/// </summary>
		private void UpdatePluginList() {
			this.pluginListView.Items.Clear();
			foreach (Client plugin in PluginManager.Instance.Plugins) {
				ListViewItem viewItem = new ListViewItem(plugin.Name);
				viewItem.Tag = plugin;
				this.pluginListView.Items.Add(viewItem);
			}
		}

		/// <summary>
		/// L[蓖āiPj^u uV蓖ĂL[ṽeLXg{bNXKeyDownCxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void newKey_KeyDown(object sender, KeyEventArgs e) {
			if (actionList.SelectedItems.Count < 1) {
				newKey.Text = "ŏɃL[蓖Ă@\IĂ";
			} else if (KeyCommandManager.Instance.IsValidCommand(e.Control, e.Alt, e.Shift, e.KeyCode)) {
				newKey.Text = KeyCommandManager.Instance.GetCommandString(e.Control, e.Alt, e.Shift, e.KeyCode);
			} else {
				newKey.Text = "";
			}
			e.Handled = true;
		}

		/// <summary>
		/// L[蓖āiPj^u uV蓖ĂL[ṽeLXg{bNXKeyPressCxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void newKey_KeyPress(object sender, KeyPressEventArgs e) {
			//KeyDownCxgŏ邩炱͉Ȃ
			e.Handled = true;
		}

		/// <summary>
		/// L[蓖āiPj^u ANVXg̑IύXCxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void actionList_SelectedIndexChanged(object sender, EventArgs e) {
			//łɊ蓖čς݂ꍇ̓eLXg{bNXɊ蓖čς݂̃L[\
			if (actionList.SelectedItems.Count > 0) {
				ActionManager.ActionID actionID = (ActionManager.ActionID)actionList.SelectedItems[0].Tag;
				oldKey.Text = KeyCommandManager.Instance.GetAssignedKeyCommand(actionID);
				newKey.Text = "";
			}
		}

		/// <summary>
		/// L[蓖āiPj^u@ANV^CṽR{{bNX̑IύXCxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void actionTypeComboBox_SelectedIndexChanged(object sender, EventArgs e) {
			//R{{bNXŐݒ肳Ă^CvAction̂ListViewɒǉ
			actionList.Items.Clear();
			foreach (ActionManager.ActionID id in ActionManager.AllActionID) {
				Action action = ActionManager.CreateAction(id);
				string displayString = ActionManager.GetDisplayString(id);
				//"S"IĂ鎞͖ɁAȊÓA^Cvvo^
				if ((string)actionTypeComboBox.SelectedItem == allActionOptionString
					|| (string)actionTypeComboBox.SelectedItem == action.TypeString) {
					ListViewItem item = new ListViewItem(action.DisplayString);
					item.Tag = id;
					actionList.Items.Add(item);
				} else {
					//o^Ȃ
				}
			}
		}

		/// <summary>
		/// JX^c[o[^u@JX^c[o[̃ACeXgĩXgj̑IύXCxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void customToolbarList_SelectedIndexChanged(object sender, EventArgs e) {
			if (this.customToolbarList.SelectedItems.Count == 0) {
				return;
			}

			ListViewItem item = this.customToolbarList.SelectedItems[0];
			for (int i=0;i<this.actionListComboBox.Items.Count; i++) {
				Action action = (Action)this.actionListComboBox.Items[i];
				if (action.DisplayString == item.Text) {
					this.actionListComboBox.SelectedItem = action;
					return;
				}
			}
		}

		/// <summary>
		/// JX^c[o[^u@uQƁv{^̃Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void iconSelectDialogButton_Click(object sender, EventArgs e) {
			OpenFileDialog dialog = new OpenFileDialog();
			dialog.CheckFileExists = true;
			dialog.DefaultExt = "ico";
			System.IO.FileInfo info = new System.IO.FileInfo(Application.ExecutablePath);
			dialog.InitialDirectory = info.DirectoryName + @"\icons";
			if (iconFileTextBox.Text != "" && System.IO.File.Exists(dialog.InitialDirectory + @"\" + iconFileTextBox.Text)) {
				dialog.FileName = iconFileTextBox.Text;
			}
			dialog.Multiselect = false;
			dialog.RestoreDirectory = true;
			DialogResult result = dialog.ShowDialog();
			if (result == DialogResult.OK) {
				iconFileTextBox.Text = System.IO.Path.GetFileName(dialog.FileName);
			}
		}

		/// <summary>
		/// JX^c[o[^u@uǉv{^̃Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void CustomToolbarAddButton_Click(object sender, EventArgs e) {
			if (actionListComboBox.SelectedItem == null) {
				MessageBox.Show("ANVIĂ܂");
				return;
			}

			System.IO.FileInfo info = new System.IO.FileInfo(Application.ExecutablePath);
			string iconFilename = info.DirectoryName + @"\icons\" + iconFileTextBox.Text;
			if (this.IsUseExeIconCheckBox.Checked == false &&
				(!System.IO.File.Exists(iconFilename) || System.IO.Path.GetExtension(iconFilename) != ".ico")) {
				MessageBox.Show("L.icot@CIĂ܂BsvOicontH_ɂgq.icõt@CłKv܂");
				return;
			}
			//Oc[ǂׂi܂ݒ肳ĂȂOc[returnj
			ExecuteExternalTool tool = (Action)this.actionListComboBox.SelectedItem as ExecuteExternalTool;
			if (tool != null) {
				if (ExternalToolManager.Instance.GetItem(tool.Index) == null) {
					MessageBox.Show("܂Oc[o^Ă܂");
					return;
				}
			}
			Action action = (Action)actionListComboBox.SelectedItem;
			ListViewItem newItem = new ListViewItem(action.DisplayString);

			CustomToolbarItem customItem;
			if (this.IsUseExeIconCheckBox.Enabled == true && this.IsUseExeIconCheckBox.Checked == true) {
				customItem = new CustomToolbarItem(action.DisplayString, true, "");
			} else {
				customItem = new CustomToolbarItem(action.DisplayString, iconFileTextBox.Text);
			}
			newItem.Tag = customItem;
			customToolbarList.Items.Add(newItem);
		}

		/// <summary>
		/// JX^c[o[^u u폜v{^̃Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void deleteCustomToolbarItem_Click(object sender, EventArgs e) {
			if (customToolbarList.SelectedItems.Count == 0) {
				MessageBox.Show("ACeIĂ܂");
				return;
			}
			customToolbarList.Items.Remove(customToolbarList.SelectedItems[0]);
		}

		/// <summary>
		/// JX^c[o[^u@uցv{^̃Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void upCustomToolbarItemButton_Click(object sender, EventArgs e) {
			if (this.customToolbarList.SelectedItems.Count == 0) {
				MessageBox.Show("ACeIĂ܂");
				return;
			} else if (this.customToolbarList.SelectedItems[0].Index == 0) {
				//ԏ̃ACe牽Ȃ
				return;
			}
			int index = this.customToolbarList.SelectedItems[0].Index;
			ListViewItem exchangeTarget = this.customToolbarList.Items[index -1]; //Ώۂ̃ACe
			this.customToolbarList.Items.Remove(exchangeTarget);
			this.customToolbarList.Items.Insert(index, exchangeTarget);
		}

		/// <summary>
		/// JX^c[o[^u uցv{^̃Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void downCustomToolbarItemButton_Click(object sender, EventArgs e) {
			if (this.customToolbarList.SelectedItems.Count == 0) {
				MessageBox.Show("ACeIĂ܂");
			} else if (this.customToolbarList.SelectedItems[0].Index == this.customToolbarList.Items.Count - 1) {
				//ԉ̃ACe牽Ȃ
				return;
			}
			int index = this.customToolbarList.SelectedItems[0].Index;
			ListViewItem exchangeTarget = this.customToolbarList.Items[index + 1];
			this.customToolbarList.Items.Remove(exchangeTarget);
			this.customToolbarList.Items.Insert(index, exchangeTarget);
		}

		/// <summary>
		/// JX^c[o[^u@ANVꗗ̃R{{bNX̑IύX̃Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void actionListComboBox_SelectedIndexChanged(object sender, EventArgs e) {
			Action act = (Action)this.actionListComboBox.SelectedItem;
			ExecuteExternalTool tool = act as ExecuteExternalTool;
			if (tool != null) {
				this.IsUseExeIconCheckBox.Enabled = true;
			} else {
				this.IsUseExeIconCheckBox.Enabled = false;
			}
		}

		/// <summary>
		/// JX^c[o[^u@ust@C̃ACRgpv`FbN{bNX̃Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void isUseExeIconCheckBox_CheckedChanged(object sender, EventArgs e) {
			if (this.IsUseExeIconCheckBox.Enabled == true && this.IsUseExeIconCheckBox.Checked == true) {
				this.iconFileTextBox.Enabled = false;
			} else {
				this.iconFileTextBox.Enabled = true;
			}
		}

		private void oldKey_TextChanged(object sender, EventArgs e) {
			if (this.oldKey.Text == "") {
				releaseKeyAssignButton.Enabled = false;
			} else {
				releaseKeyAssignButton.Enabled = true;
			}
		}

		/// <summary>
		/// L[蓖āiPj^u u蓖ĉv{^Ƃ̃L[Cxg
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void releaseKeyAssignButton_Click(object sender, EventArgs e) {
			if (actionList.SelectedItems.Count == 0) {
				SCFiler2System.ShowDialogMessage("ΏۂIĂ܂");
				return;
			}

			ActionManager.ActionID actionID = (ActionManager.ActionID)actionList.SelectedItems[0].Tag;
			KeyCommandManager.Instance.ReleaseAssignedKey(actionID);
			KeyCommandManager.Instance.Save();
			SCFiler2System.ShowDialogMessage("蓖Ă܂");
			this.oldKey.Text = "";
		}

		private void ExtensionRelationCustomAddButton_Click(object sender, EventArgs e) {
			ExtensionRelationCustomForm dialog = new ExtensionRelationCustomForm();
			DialogResult result = dialog.ShowDialog();
			if (result == DialogResult.OK && dialog.InputItem != null) {
				ExtensionRelationCustomize.Instance.Add(dialog.InputItem);
				ExtensionRelationCustomize.Instance.Save();
				this.UpdateExtensionRelationCustomizeList();
			}
		}

		private void tabPage9_Click(object sender, EventArgs e) {

		}

		private void ExtensionRelationCustomizeDeleteButton_Click(object sender, EventArgs e) {
			if (this.ExtensionRelationCustomizeListbox.SelectedItems.Count == 1) {
				ExtensionRelationCustomize.Instance.Remove(this.ExtensionRelationCustomizeListbox.SelectedItems[0].Index);
				ExtensionRelationCustomize.Instance.Save();
				this.UpdateExtensionRelationCustomizeList();
			}
		}

		private void button1_Click(object sender, EventArgs e) {
			this.EditExtensionRelationCustomizeListItem();
		}

		private void EditExtensionRelationCustomizeListItem() {
			int index = ExtensionRelationCustomizeListbox.SelectedItems[0].Index;
			ExtensionRelationCustomize.Item item = (ExtensionRelationCustomize.Item)this.ExtensionRelationCustomizeListbox.SelectedItems[0].Tag;
			ExtensionRelationCustomForm dialog = new ExtensionRelationCustomForm();
			DialogResult result = dialog.ShowDialog(item.expression.ToString(), item.num);
			if (result == DialogResult.OK && dialog.InputItem != null) {
				ExtensionRelationCustomize.Instance.Update(index, dialog.InputItem);
				ExtensionRelationCustomize.Instance.Save();
				this.UpdateExtensionRelationCustomizeList();
			}
		}

		private void ExtensionRelationCustomizeListbox_DoubleClick(object sender, EventArgs e) {
			this.EditExtensionRelationCustomizeListItem();
		}

		private void newKeyForPluginTextBox_TextChanged(object sender, EventArgs e) {

		}

		private void AssignKeyToPluginButton_Click(object sender, EventArgs e) {
			string command = this.newKeyForPluginTextBox.Text;

			Client plugin = KeyCommandManager.Instance.GetAssignedPlugin(command);

			if (plugin != null) {
				SCFiler2System.ShowDialogMessage("̃L[͂ł" + plugin.Name + "Ɋ蓖ĂĂ܂");
				return;
			}
			KeyCommandManager.Instance.RegistPlugin((Client)this.pluginListView.SelectedItems[0].Tag, command);
			KeyCommandManager.Instance.Save();
			SCFiler2System.ShowDialogMessage("L[蓖Ă܂");
	
		}

		private void pluginListView_KeyDown(object sender, KeyEventArgs e) {

		}

		private void newKeyForPluginTextBox_KeyDown(object sender, KeyEventArgs e) {
			if (KeyCommandManager.Instance.IsValidCommand(e.Control, e.Alt, e.Shift, e.KeyCode)) {
				newKeyForPluginTextBox.Text = KeyCommandManager.Instance.GetCommandString(e.Control, e.Alt, e.Shift, e.KeyCode);
			} else {
				newKeyForPluginTextBox.Text = "";
			}
			e.Handled = true;
		}

		private void pluginListView_SelectedIndexChanged(object sender, EventArgs e) {
			if (this.pluginListView.SelectedItems.Count == 0) {
				return;
			}

			Client plugin = (Client)this.pluginListView.SelectedItems[0].Tag;
			string command = KeyCommandManager.Instance.GetAssignedKeyCommand(plugin);

			this.oldKeyForPluginTextBox.Text = command;
		}

		private void releaseKeyAssignForPluginButton_Click(object sender, EventArgs e) {
			if (this.pluginListView.SelectedItems.Count == 0) {
				return;
			}

			Client plugin = (Client)this.pluginListView.SelectedItems[0].Tag;
			KeyCommandManager.Instance.ReleaseAssignedKey(plugin);
		}

		private void oldKeyForPluginTextBox_TextChanged(object sender, EventArgs e) {
			if (this.oldKeyForPluginTextBox.Text == "") {
				this.oldKeyForPluginTextBox.Enabled = false;
			} else {
				this.oldKeyForPluginTextBox.Enabled = true;
			}
		}

	}
}