using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using System.Diagnostics;
using System.ComponentModel;
using SCFiler2.ItemInterface;
using SCFiler2.ViewInterface;

namespace SCFiler2 {
	/// <summary>
	/// t@Cr[ŎgReLXgj[BVOg
	/// </summary>
	public class ViewContextMenu {
		static private ViewContextMenu instance = new ViewContextMenu();
		static public ViewContextMenu Instance {
			get { return instance; }
		}

		private ContextMenu contextMenu = new ContextMenu();
		private MenuItem sendtoMenu;

		/// <summary>
		/// ACeɉReLXgj[擾
		/// </summary>
		/// <param name="item">ReLXgj[擾ACeBėpIȂ̂~ꍇnull</param>
		/// <returns>ReLXgj[</returns>
		public ContextMenu GetContextMenu(IFilerItem item) {
			contextMenu.MenuItems.Clear();

			//gqɊ֘AÂĂ郁j[擾
			//T.B.D

			//SendTo͌Œœ̂g
			contextMenu.MenuItems.Add(sendtoMenu);
			return contextMenu;
		}

		public ContextMenu GetHistoryViewContextMenu(List<IFilerItem> itemList) {
			contextMenu.MenuItems.Clear();

			if (itemList.Count == 1 && itemList[0].Type == ItemType.File) {
				MenuItem openByFileViewMenuItem = new MenuItem("tH_J", OpenByActiveFileView);
				openByFileViewMenuItem.Tag = itemList[0].Path;
				contextMenu.MenuItems.Add(openByFileViewMenuItem);
			}
			
			contextMenu.MenuItems.Add(sendtoMenu);
			return contextMenu;
		}

		private ViewContextMenu() {
			//sendTo͋Nɍ̂݁iptH[}XlăA^Cō\zȂj
			sendtoMenu = ConstructSendToContextMenu();
		}

		/// <summary>
		/// ""j[
		/// </summary>
		/// <returns>쐬MenuItem</returns>
		private MenuItem ConstructSendToContextMenu() {
			string sendtoFolder = Environment.GetFolderPath(Environment.SpecialFolder.SendTo);
			string[] sendtoFiles = System.IO.Directory.GetFiles(sendtoFolder);
			MenuItem sendtoMenuItem = new MenuItem("SendTo");
			foreach (string file in sendtoFiles) {
				MenuItem item = new MenuItem(System.IO.Path.GetFileNameWithoutExtension(file),SendToEventHandler);
				item.Tag = file;
				sendtoMenuItem.MenuItems.Add(item);
			}
			return sendtoMenuItem;
		}

		/// <summary>
		/// ۂSendTõj[NbNꂽ̃Cxgnh
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SendToEventHandler(Object sender, EventArgs e) {
			//ǂ̎st@CŎsΗǂ́AMenuItemTag󂯎

			MenuItem menuItem = (MenuItem)sender;
			string exeProgram = (string)menuItem.Tag;
			MainForm mainForm = MainForm.Instance;
			List<IFilerItem> selectedItems = null;
			string currentPath = @"C:\";
			if (ViewInterfaces.CurrentItemView.Type == ViewType.FileView) {
				selectedItems = ViewInterfaces.LastFocusedFileView.SelectedFilerItems;
				currentPath = ViewInterfaces.LastFocusedFileView.CurrentPath;
			} else if (ViewInterfaces.CurrentItemView.Type == ViewType.HistoryView) {
				selectedItems = ViewInterfaces.LastFocusedFileView.SelectedFilerItems;

				//Ƃ肠JgpX́AHistoryVieŵPڂ̑IACẽpXƉ
				File file = (File)ViewInterfaces.CurrentItemView.SelectedFilerItems[0];
				currentPath = file.Path;
			} else {
				SCFiler2System.ShowTempMessage("Lȃr[ɃtH[JX܂");
				return;
			}

			if (selectedItems.Count == 0) {
				SCFiler2System.ShowTempMessage("ACeIĂ܂");
				return;
			}

			string targetFiles = "";
			foreach (IFilerItem item in selectedItems) {
				targetFiles += "\"" + item.FullName + "\" ";
			}
			//vZX̎s
			ProcessStartInfo startInfo = new ProcessStartInfo(exeProgram);
			startInfo.WorkingDirectory = currentPath;
			startInfo.Arguments = targetFiles;
			try {
				Process.Start(startInfo);
			} catch (Win32Exception) {
				SCFiler2System.ShowDialogMessage("t@CI𐔂Ȃǂ̗RŊJ܂");
			}
		}

		private void OpenByActiveFileView(Object sender, EventArgs e) {
			MenuItem item = (MenuItem)sender;
			string path = (string)item.Tag;

			if (System.IO.Directory.Exists(path)) {
				IFileView view = ViewInterfaces.LastFocusedFileView;
				view.ChangePath(path);
				view.Focus();
			} else {
				SCFiler2System.ShowHistoryMessage(path + "݂͑܂");
			}
		}
	}
}
