using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.ItemInterface;

namespace SCFiler2.ListViewControl {
	/// <summary>
	/// VirtualModeListView߂́AListVieŵ
	/// </summary>
	public class VirtualListView {
		public enum IconListIndex : int {
			Folder = 0,
			Hdd = 1,
			CDROM = 2,
			Removable = 3,
			NetworkDrive = 4,
		}

		private ListView targetView;
		/// <summary>
		/// ̃r[ǗVIrtualListViewItem̃Xg
		/// </summary>
		private List<VirtualListViewItem> itemList;
		private VirtualListViewItem focusedItem;
		private VirtualListViewItemCollection itemCollection;
		private SelectedVirtualListViewItemCollection selectedItemCollection;
		private SelectedIndexCollection selectedIndexCollection;
		private VirtualListViewComparer sorter;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="targetView">VirtualListViewǗΏۂListView</param>
		public VirtualListView(ListView targetView) {
			this.targetView = targetView;
			this.itemList = new List<VirtualListViewItem>();
			this.itemCollection = new VirtualListViewItemCollection(this);
			this.selectedItemCollection = new SelectedVirtualListViewItemCollection(this);
			this.selectedIndexCollection = new SelectedIndexCollection(this);
			this.sorter = new VirtualListViewComparer(0);
			this.targetView.SmallImageList = new ImageList();
			this.targetView.LargeImageList = new ImageList();
			this.InitializeImageList();
		}


		/// <summary>
		/// VirtualListViewǗΏۂListView擾
		/// </summary>
		public ListView AssignedListView {
			get { return this.targetView; }
		}

		/// <summary>
		/// VirtualListView̓eNA
		/// </summary>
		public void Clear() {
			this.itemCollection.Clear();
			this.InitializeImageList();
			this.targetView.VirtualListSize = 0;
		}

		/// <summary>
		/// VirtualListViewǗSĂitemԂ
		/// </summary>
		public VirtualListViewItemCollection Items {
			get { return this.itemCollection; }
		}

		/// <summary>
		/// ݃tH[JXĂitem
		/// </summary>
		public VirtualListViewItem FocusedItem {
			get {
				if (this.targetView.FocusedItem == null) {
					return null;
				} else {
					return this.itemList[this.targetView.FocusedItem.Index];
				}
			}
			set {
				if (value == null) {
					this.targetView.FocusedItem = null;
				} else {
					this.targetView.FocusedItem = value.Item;
				}
			}
		}

		/// <summary>
		/// IĂACeindex̃XgBXg̏Ԃ͒ǉꂽ
		/// </summary>
		public SelectedIndexCollection SelectedIndices {
			get { return this.selectedIndexCollection; }
		}

		/// <summary>
		/// r[̕\̈̈ԏɕ\ĂACe
		/// </summary>
		public VirtualListViewItem TopItem {
			get {
				return this.itemList[this.targetView.TopItem.Index];
			}
			set {
				this.targetView.TopItem = value.Item;
			}
		}

		/// <summary>
		/// IĂACẽRNV
		/// </summary>
		public SelectedVirtualListViewItemCollection SelectedItems {
			get { return this.selectedItemCollection; }
		}

		/// <summary>
		/// ĕ`(ListViewUpdate)
		/// </summary>
		public void Update() {
			this.targetView.Update();
		}

		/// <summary>
		/// ĕ`(ListViewRefresh)
		/// </summary>
		public void Refresh() {
			this.targetView.Refresh();
		}

		/// <summary>
		/// indexԍ̃ACeʕ\̈ɂ͂悤ɃXN[
		/// </summary>
		/// <param name="index">\ACeindex</param>
		public void EnsureVisible(int index) {
			this.targetView.EnsureVisible(index);
		}

		public void BeginUpdate() {
			this.targetView.BeginUpdate();
		}

		public void EndUpdate() {
			this.targetView.EndUpdate();
		}

		/// <summary>
		/// w肵WɂACe擾
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns>擾ACeBΉ̂ȂꍇnullԂ</returns>
		public VirtualListViewItem GetItemAt(int x, int y) {
			ListViewItem listViewItem = this.targetView.GetItemAt(x, y);
			foreach (VirtualListViewItem virtualItem in this.Items) {
				if (virtualItem.Item == listViewItem) {
					return virtualItem;
				}
			}
			return null;
		}

		/// <summary>
		/// ListView̕`̈̃TCY擾
		/// </summary>
		public System.Drawing.Size ClientSize {
			get {
				return this.targetView.ClientSize;
			}
		}

		public void Sort(FileView.ColumnType columnType) {
			int oldColumn = sorter.getColumn();
			this.targetView.Columns[oldColumn].Text = (string)this.targetView.Columns[oldColumn].Tag;

			sorter.setColumn((int)columnType);
			if (sorter.Order == SortOrder.Ascending) {
				this.targetView.Columns[(int)columnType].Text = (string)this.targetView.Columns[(int)columnType].Tag + "";
			} else {
				this.targetView.Columns[(int)columnType].Text = (string)this.targetView.Columns[(int)columnType].Tag + "";
			}
			this.itemList.Sort(this.sorter);
		}

		public void Sort() {
			this.itemList.Sort(this.sorter);
		}

		#region Imageindex֌W
		private Dictionary<string, int> smallImageListDictionary = new Dictionary<string, int>();

		internal void InitializeImageList() {
			this.targetView.SmallImageList.Images.Clear();
			this.targetView.LargeImageList.Images.Clear();
			this.targetView.SmallImageList.Images.Add(Images.Folder);
			this.targetView.SmallImageList.Images.Add(Images.Hdd);
			this.targetView.SmallImageList.Images.Add(Images.CDROM);
			this.targetView.SmallImageList.Images.Add(Images.RemovableDrive);
			this.targetView.SmallImageList.Images.Add(Images.NetworkDrive);
			this.smallImageListDictionary.Clear();
		}

		/// <summary>
		/// 摜Kvɉēo^AListViewItemImageIndexɐݒ肷ׂintl擾
		/// gq̃ACR͎g
		/// </summary>
		/// <param name="target"></param>
		/// <returns></returns>
		internal int RegistSmallImage(FilerItem target) {
			string keyUpper = target.Extension.ToUpper();

			if (target.Extension.ToUpper() == ".EXE") { // exe͖ʂIconǂݍ
				this.targetView.SmallImageList.Images.Add(target.Icon);
				return this.targetView.SmallImageList.Images.Count - 1;
			} else {
				if (smallImageListDictionary.ContainsKey(keyUpper)) {
					return this.smallImageListDictionary[keyUpper];
				} else {
					this.targetView.SmallImageList.Images.Add(target.Icon);
					int index = this.targetView.SmallImageList.Images.Count - 1;
					this.smallImageListDictionary.Add(keyUpper, index);
					return index;
				}
			}
		}

		#endregion

		/// <summary>
		/// VirtualListViewǗĂACẽRNV
		/// </summary>
		public class VirtualListViewItemCollection : IEnumerable {
			/// <summary>
			/// ̃RNVĂr[ւ̎Q
			/// </summary>
			private VirtualListView parentView;
			/// <summary>
			/// RXgN^
			/// </summary>
			/// <param name="itemList">̃RNVɑACẽXg</param>
			/// <param name="parentView">̃RNVĂr[</param>
			public VirtualListViewItemCollection(VirtualListView parentView) {
				this.parentView = parentView;
			}

			/// <summary>
			/// ACe̐
			/// </summary>
			public int Count {
				get { return this.parentView.itemList.Count; }
			}

			public void Clear() {
				this.parentView.itemList.Clear();
				this.parentView.AssignedListView.VirtualListSize = 0;
			}

			/// <summary>
			/// indexŕ\ACe擾
			/// </summary>
			/// <param name="index">擾ACeindex</param>
			/// <returns>indexԖVirtualListViewItem</returns>
			public VirtualListViewItem this[int index] {
				get { return this.parentView.itemList[index]; }
			//	set { this.parentView.itemList[index] = value; }
			}

			/// <summary>
			/// r[ɃACeǉ
			/// </summary>
			/// <param name="item">ǉACe</param>
			public void Add(VirtualListViewItem item) {
				this.parentView.itemList.Add(item);
				item.AssignVirtualListView(this.parentView);
				this.parentView.AssignedListView.VirtualListSize = this.parentView.itemList.Count;
			}

			/// <summary>
			/// r[ACe폜
			/// </summary>
			/// <param name="item"></param>
			public void Remove(VirtualListViewItem item) {
				this.parentView.itemList.Remove(item);
				if (this.parentView.AssignedListView.SelectedIndices.Contains(item.Index)) {
					this.parentView.AssignedListView.SelectedIndices.Remove(item.Index);
				}
				this.parentView.AssignedListView.VirtualListSize = this.parentView.itemList.Count;
			}

			/// <summary>
			/// ACeindex擾
			/// </summary>
			/// <param name="item">index擾ACe</param>
			/// <returns>itemɑΉindex</returns>
			public int IndexOf(VirtualListViewItem item) {
				return this.parentView.itemList.IndexOf(item);
			}

			#region IEnumerable o

			IEnumerator IEnumerable.GetEnumerator() {
				return this.parentView.itemList.GetEnumerator();
			}

			#endregion
		}


		/// <summary>
		/// IĂACe擾邽߂̃RNV
		/// </summary>
		public class SelectedVirtualListViewItemCollection : IEnumerable {
			private VirtualListView parentView;

			//{IVirtualListViewNXĂ𗘗p
			//C^[tFCX

			/// <summary>
			/// RXgN^
			/// </summary>SCFiler2.ListViewControl.ListViewController.Result
			/// <param name="itemList">VirtualListViewĂSItem̃Xg</param>
			/// <param name="parentView">̃RNVĂr[</param>
			public SelectedVirtualListViewItemCollection(VirtualListView parentView) {
				this.parentView = parentView;
			}

			/// <summary>
			/// ̃RNVɊ܂܂Item̐
			/// </summary>
			public int Count {
				get { return this.parentView.AssignedListView.SelectedIndices.Count; }
			}

			public VirtualListViewItem this[int index] {
				get { return this.parentView.itemList[this.parentView.AssignedListView.SelectedIndices[index]];}
			}

			/// <summary>
			/// ACeRNVɊ܂܂邩ǂԂ
			/// </summary>
			/// <param name="item">ׂΏۂitem</param>
			/// <returns>܂܂Ătrue</returns>
			public bool Contains(VirtualListViewItem item) {
				return this.parentView.AssignedListView.SelectedIndices.Contains(item.Index);
			}

			/// <summary>
			/// SẴACȇI
			/// </summary>
			public void Clear() {
				this.parentView.AssignedListView.SelectedIndices.Clear();
			}

			public void Add(VirtualListViewItem item) {
				if (this.parentView.AssignedListView.SelectedIndices.Contains(item.Index)) {
				} else {
					this.parentView.AssignedListView.SelectedIndices.Add(item.Index);
				}
			}

			public void Remove(VirtualListViewItem item) {
				if (this.parentView.AssignedListView.SelectedIndices.Contains(item.Index)) {
					this.parentView.AssignedListView.SelectedIndices.Remove(item.Index);
				}
			}

			/// <summary>
			/// RNVIFilerItem̃XgɕϊĕԂ
			/// </summary>
			public List<IFilerItem> FilerItems {
				get {
					List<IFilerItem> items = new List<IFilerItem>();
					foreach ( int index in this.parentView.AssignedListView.SelectedIndices) {
						items.Add(this.parentView.itemList[index].FilerItem);
					}

					return items;
				}
			}

			#region IEnumerable o

			IEnumerator IEnumerable.GetEnumerator() {
				foreach (int index in this.parentView.AssignedListView.SelectedIndices) {
					yield return this.parentView.itemList[index];
				}
			}

			#endregion
		}
		public class SelectedIndexCollection : IEnumerable {
			//IԂVirtualListView.SelectedItemsŊǗ

			VirtualListView parentView;

			public SelectedIndexCollection(VirtualListView parentView) {
				this.parentView = parentView;
			}

			public int this[int index] {
				get { return this.parentView.AssignedListView.SelectedIndices[index]; }
			}

			/// <summary>
			/// ێvf̐
			/// </summary>
			public int Count {
				get { return this.parentView.AssignedListView.SelectedIndices.Count; }
			}

			public bool Contains(int index) {
				return this.parentView.AssignedListView.SelectedIndices.Contains(index);
			}


			#region IEnumerable o

			IEnumerator IEnumerable.GetEnumerator() {
				foreach (int index in this.parentView.AssignedListView.SelectedIndices) {
					yield return index;
				}
			}

			#endregion

		}
	}
}
