/*
 * ADS1259
 * 
 * AD
 * SPIエンディアン MSB first
 */
#include <p24FJ64GA004.h>
#include <libpic30.h>

#include "delay.h"
#include "myspi.h"
#include "myad.h"

void ad_cs_init(void)
{
    asm("NOP");
    CS_RCLK = 0;
    asm("NOP");
    CS_CLK = 0;
    asm("NOP");
    CS_DATA = 0;
}

void ad_reset(void)
{
    PORTBbits.RB10 = 1; // -AD RESET
    delay_us(1);
    PORTBbits.RB10 = 0; // -AD RESET
    delay_ms(1);
    PORTBbits.RB10 = 1; // -AD RESET
}
void ad_start(void)
{
    PORTBbits.RB11 = 1; // +AD START
    delay_us(1);
    PORTBbits.RB11 = 0; // +AD START
}
// polling send
void ad_spi_send(unsigned char c)
{
    while(spi1_tx_fifo_is_full());
    spi1_putc(c);
}
// polling send/rcv
unsigned char ad_spi_rcv(unsigned char c)
{
    spi1_rx_overrun_clear();
    while(spi1_tx_fifo_is_full());
    // 前に受信したデータをクリア
    spi1_getc();
    // 送信
    spi1_putc(c);
    // 受信待ち
    while(!spi1_rx_fifo_is_full());
    return spi1_getc();
}

void ad_init(void)
{
    int cs;
    int i;
    for(i = 0; i < AD_CHNUM; i++) {
        cs = AD_CH1_CS + i;
    //1. Send the SDATAC command <11h>. This command cancels the RDATAC mode. RDATAC mode must be
    //cancelled before the register write commands.

        ad_cs(cs);
            ad_spi_send(ADCMD_SDATAC);
        ad_cs_dis();
    //2. Send the register write command. The following example shows the register write as a block of nine bytes,
    //starting at register 0 (CONFIG0).
        ad_cs(cs);
            ad_spi_send(ADCMD_WREG | 0);	// Register write command
            ad_spi_send(9 - 1);		// 9byte write
            // CONFIG0: RFBIAS OFF, SPI timeout enable
            // Bit 2 RBIAS: Internal reference bias
            //  0 = Internal reference bias disabled
            //  1 = Internal reference bias enabled (default)
            // Bit 0 SPI: SCLK timeout of SPI interface
            //  0 = SPI timeout disabled
            //  1 = SPI timeout enabled (default), when SCLK is held low for 216 clock cycles
            //         bit76543210
            ad_spi_send(0b00000101);
            // CONFIG1: sinc1 filter, EXTREF ON, START delay = 0
            // Bit 6 CHKSUM: Checksum
            //  0 = Disabled (default)
            //  1 = Conversion data checksum byte included in readback
            // Bit 4 SINC2: Digital filter mode
            //  0 = sinc1 filter (default)
            //  1 = sinc2 filter
            // Bit 3 EXTREF: Reference select
            //  0 = Internal
            //  1 = External (default)
            // Bits 2-0 DELAY[2:0]: START conversion delay
            //  000 = No delay (default)
            //         bit76543210
            ad_spi_send(0b00001000);


            // CONFIG2: SYNCOUT ON, Gate control, DataRate=10Hz
            // Bit 5 SYNCOUT: SYNCOUT clock enable
            //  0 = SYNCOUT disabled (default)
            //  1 = SYNCOUT enabled
            // Bit 4 PULSE: Conversion Control mode select
            //  0 = Gate Control mode (default)
            //  1 = Pulse Control mode
            // Bits 2-0 DR[2:0] Data rate setting
            //  000 = 10SPS (default)
            //  001 = 16.6SPS
            //  010 = 50SPS
            //  011 = 60SPS
            //  100 = 400SPS
            //  101 = 1200SPS
            //  110 = 3600SPS
            //  111 = 14400SPS
            //  NOTE: fCLK = 7.3728MHz
            unsigned char rate_bit;
            switch(AD_SAMPLE) {
                case 50:
                    rate_bit = 0b00000010;
                    break;
                case 400:
                    rate_bit = 0b00000100;
                    break;
                default:
                case 10:
                    rate_bit = 0b00000000;
                    break;
            }
            //         bit76543210
            ad_spi_send(0b00100000 | rate_bit);

            // OFC0,1,2: no offset correction
            ad_spi_send(0);
            ad_spi_send(0);
            ad_spi_send(0);

            // FSC0,1,2: no full scale correction
            ad_spi_send(0);
            ad_spi_send(0);
            ad_spi_send(0b01000000);
        ad_cs_dis();

    }
    // 4. Take the START pin high or send the START command to start conversions.
    ad_start_ena(); // +AD START

    for(i = 0; i < AD_CHNUM; i++) {
        cs = AD_CH1_CS + i;
        //5. Optionally, send the RDATAC command <10h>. This permits reading of conversion data without the need of
        //the read data command. Otherwise, the read data opcode must be sent to read each conversion result.
        ad_cs(cs);
            ad_spi_send(ADCMD_RDATAC);
        ad_cs_dis();
    }

}
/*
 * PGA280 init
 * BUF OFF
 * SYNCin enable
*/
void pga_init(void)
{
    int cs;
    int i;
    for(i = 0; i < AD_CHNUM; i++) {
        cs = PGA_CH1_CS + i;
        //Register 1
        //Soft Reset
        ad_cs(cs);
            ad_spi_send(0x41);
            ad_spi_send(0x01);
        ad_cs_dis();
        //waitいる?
        delay_ms(1);

        //Register 0
        //Gain=1/4
        ad_cs(cs);
            ad_spi_send(0x40);  //(BUF OFF)
            ad_spi_send(0x08);
        ad_cs_dis();

        //Register 8: GPIO Configuration Register
        //使わないpinはoutput(=1)にする
        //bit6 GPIO6(SYNCIN) input(=0)
        ad_cs(cs);
            ad_spi_send(0x48);
            ad_spi_send(0b00111111);
        ad_cs_dis();

        //Register 12: Special Functions Register
        //bit6 SYNCin=1 SYNCIN(GPIO6) Enable
        ad_cs(cs);
            ad_spi_send(0x4C);
            ad_spi_send(0b01000000);
        ad_cs_dis();
    }
}

/*
 * PGA280 Gain set
 * int ch: 0〜AD_CHNUM-1
 * int gatin: 0〜10
 *      0=1/8, 1=1/4, 2=1/2, 3=1, 4=2, 5=4
 *      6=8, 7=16, 8=32, 9=64, 10=128
 */
void pga_gain_set(int ch, int gain)
{
    int cs;
    int i;
    for(i = 0; i < AD_CHNUM; i++) {
        cs = PGA_CH1_CS + ch;
        // Register 0
        // bit6-3: Gain
        ad_cs(cs);
            ad_spi_send(0x40);  //(BUF OFF)
            ad_spi_send((gain << 3) & 0x78);
        ad_cs_dis();
    }
}
