#ifndef __UBLOX_H__

#define __UBLOX_H__

#include "myuart.h"

// UBXパケットID
#define UBX_CLS_CFG  0x06
#define UBX_CLS_NAV  0x01

// CFG-
#define UBX_ID_CFG_PRT  0x00
#define UBX_ID_CFG_TP5  0x31
#define UBX_ID_CFG_MSG  0x01
// NAV-
#define UBX_ID_NAV_TIMEUTC  0x21

#define UBX_LEN_NAV_TIMEUTC 20

// NAV-TIMEUTCパケットのデータ格納
// SPI送信にそのまま使われるので注意！
typedef struct {
    unsigned long   tow;    // ms GPS Millisecond Time of Week
    unsigned long   tacc;   // ns Time Accuracy Estimate
    long   nano;            //ns Nanoseconds of second, range -1e9 .. 1e9 (UTC)
    unsigned int    year;   // UTC
    unsigned char   month;
    unsigned char   day;
    unsigned char   hour;
    unsigned char   min;
    unsigned char   sec;
    unsigned char   valid;  // Validity Flags
                            //  bit0 validTOW 1 = Valid Time of Week
                            //  bit1 validWKN 1 = Valid Week Number
                            //  bit2 validUTC 1 = Valid UTC (Leap Seconds already known)
} UbloxNavTimeUtc;

int ublox_make_cmd(unsigned char id1, unsigned char id2, unsigned int lenp, unsigned char *payload, unsigned char pkt[]);
void ublox_debug_pkt_out(unsigned char *pkt, int len);
void ublox_send(unsigned char *pkt, unsigned int len_pkt);

void ublox_send_cfg_prt(unsigned long bps);
void ublox_send_cfg_nmea(void);
void ublox_send_cfg_tp5_timepulse2(void);
void ublox_send_cfg_msg(void);

void ublox_send_cfg_tp5_timepulse1(void);

//void ublox_rcv_poll(void);
#define ublox_rcvbuf_clear() uart1_rcvbuf_clear()

int ublox_rcv_pkt(unsigned char *class, unsigned char *id, unsigned int *len, unsigned char *payload);
int ublox_rcv_ack(void);

#endif
