#ifndef __MYINT_H__

#define __MYINT_H__

#include <p24FJ64GA004.h>

#define int_nest_enable()   INTCON1bits.NSTDIS = 0
#define int_nest_disable()   INTCON1bits.NSTDIS = 1

#define int0_intf_clear()   IFS0bits.INT0IF = 0
#define int0_level_set(i)   IPC0bits.INT0IP = (i)
#define int0_int_enable()   IEC0bits.INT0IE = 1
#define int0_int_disable()  IEC0bits.INT0IE = 0
#define int0_edge_pos()     INTCON2bits.INT0EP = 0
#define int0_edge_neg()     INTCON2bits.INT0EP = 1

#define int1_intf_clear()   IFS1bits.INT1IF = 0
#define int1_level_set(i)   IPC5bits.INT1IP = (i)
#define int1_int_enable()   IEC1bits.INT1IE = 1
#define int1_int_disable()  IEC1bits.INT1IE = 0
#define int1_edge_pos()     INTCON2bits.INT1EP = 0
#define int1_edge_neg()     INTCON2bits.INT1EP = 1

#define int2_intf_clear()   IFS1bits.INT2IF = 0
#define int2_level_set(i)   IPC7bits.INT2IP = (i)
#define int2_int_enable()   IEC1bits.INT2IE = 1
#define int2_int_disable()  IEC1bits.INT2IE = 0
#define int2_edge_pos()     INTCON2bits.INT2EP = 0
#define int2_edge_neg()     INTCON2bits.INT2EP = 1

// Input Change Notification  IFS1<3> IEC1<3> IPC4<14:12>
#define cnint_intf_clear()  IFS1bits.CNIF = 0
#define cnint_level_set(i)  IPC4bits.CNIP = (i)
#define cnint_int_enable()  IEC1bits.CNIE = 1
#define cnint_int_disable() IEC1bits.CNIE = 0

#define INTERRUPT_PROTECT(x) { \
	char saved_ipl; \
	SET_AND_SAVE_CPU_IPL(saved_ipl,7); \
	x; \
	RESTORE_CPU_IPL(saved_ipl); } (void) 0;

#endif
