#include <p24FJ64GA004.h>

#include "myspi.h"


void spi1_rx_fifo_clear(void)
{
    int i;
    unsigned char   c;
    for(i = 0; i < 16; i++) c = SPI1BUF;
}
void spi2_rx_fifo_clear(void)
{
    int i;
    unsigned char   c;
    for(i = 0; i < 16; i++) c = SPI2BUF;
}
/*
 AD SPI1 Init
 Enhanced Buffer OFF
 master mode
*/
int spi1_init(void)
{
    int i;
    unsigned char   c;

    SPI1STAT = 0;
    //1. Clear the SPIxBUF register.
    for(i = 0; i < 16; i++) c = SPI1BUF;
    spi1_intf_clear();

    //2. Write the desired settings to the SPIxCON register with MSTEN (SPIxCON1<5>) = 1.
    // bit12 DISSCK=0 0=Internal SPI clock is enabled
    // bit11 DISSDO=0 0 = SDOx pin is controlled by the module
    // bit10 MODE16=0 8bit
    // bit9  SMP=0
    //   @MasterMode
    //   1 = Input data sampled at end of data output time
    //   0 = Input data sampled at middle of data output time
    // bit8  CKE=0 DATA CHANGE=CLK Idle to Active =LtoH
    // bit7  SSEN=0 SS pin disable
    // bit6  CKP=0 CLK IDLE=LOW
    // bit5  MSTEN=1 Master
    // bit4-2 SPRE=0b111 Secondary Prescale 1:1
    //  111 = Secondary prescale 1:1
    //  110 = Secondary prescale 2:1
    //  ...
    //  000 = Secondary prescale 8:1
    // bit1-0 PPRE=0b01 Primarily Prescale 4:1
    //  11 = Primary prescale 1:1
    //  10 = Primary prescale 4:1
    //  01 = Primary prescale 16:1
    //  00 = Primary prescale 64:1
    //           5432109876543210
    SPI1CON1 = 0b0000000000111110;

    // Enahanced Buffer(FIFO) Disable
    // bit0 SPIBEN: Enhanced Buffer Enable bit
    //  1 = Enhanced Buffer enabled
    //  0 = Enhanced Buffer disabled (Legacy mode)
    SPI1CON2 = 0x00;
//    SPI1CON2bits.SPIBEN = 1;

    // bit 4-2 SISEL2:SISEL0: SPIx Buffer Interrupt Mode bits (valid in Enhanced Buffer mode)
    //  001 = Interrupt when data is available in receive buffer (SRMPT bit is set)
//    SPI1STATbits.SISEL = 0b001;

    //3. Clear the SPIROV bit (SPIxSTAT<6>).
    SPI1STATbits.SPIROV = 0;

    //4. Enable SPIx operation by setting the SPIEN bit (SPIxSTAT<15>).
    SPI1STATbits.SPIEN = 1;

}
/*
 * DataOut SPI2 Init
 * Enhanced Buffer ON
 * Slave mode
 * SSpin enable
 * INT:
*/
int spi2_init(void)
{
    int i;
    unsigned char   c;

    SPI2STAT = 0;
    //1. Clear the SPIxBUF register.
    for(i = 0; i < 16; i++) c = SPI2BUF;
    //2. If using interrupts:
    //• Clear the SPIxIF bit in the respective IFSx register.
    IFS2bits.SPI2IF = 0;
//• Set the SPIxIE bit in the respective IECx register.
//• Write the SPIxIP bits in the respective IPCx register to set the interrupt priority.

    // 割り込み要因設定
    // 0b100 = Interrupt when one data is shifted into the SPIxSR, as a result, the TX FIFO has one open spot
    //	TX FIFOに1byte空き生じた
    SPI2STATbits.SISEL = 0b100;

    //3. Write the desired settings to the SPIxCON1 and SPIxCON2 registers with MSTEN (SPIxCON1<5>) = 0.
    // SLAVE,8bit,CLK IDLE=LOW, DATA CHANGE=CLK HtoL, SS pin enable
    //           5432109876543210
//  SPI1CON1 = 0b0000000110000000;
    SPI2CON1 = 0b0000000100000000;
    // Enahanced Buffer(FIFO) Disable
    SPI2CON2 = 0x00;
    //4. Clear the SMP bit. SPI1CON1<9>
    SPI2CON1bits.SMP = 0;
    //5. If the CKE<8> bit is set, then the SSEN<7> bit must be set, thus enabling the SSx pin.
    SPI2CON1bits.SSEN = 1;
    //6. Clear the SPIROV bit (SPIxSTAT<6>).
    SPI2STATbits.SPIROV = 0;
    //7. Select Enhanced Buffer mode by setting the SPIBEN bit (SPIxCON2<0>).
    SPI2CON2bits.SPIBEN = 1;

    //8. Enable SPI operation by setting the SPIEN bit (SPIxSTAT<15>).
    SPI2STATbits.SPIEN = 1;
}
