#if	!defined(__AD_FILE_H__)
#define	__AD_FILE_H__

#include "ad_ring.h"
#include "conf.h"

// データ記録用dir　末尾に/付けない
#ifdef	DUMMY
	#define	DIR_DATA		"/home/ntaka/dev/arm2011n/data"
#else
	#define	DIR_DATA		"/home/data"
#endif

#if 0
// NAV-TIMEUTCパケットのファイル記録用データタイプ
typedef struct {
    unsigned long   tow;    // ms GPS Millisecond Time of Week
    unsigned long   tacc;   // ns Time Accuracy Estimate
    long   nano;            // ns Nanoseconds of second, range -1e9 .. 1e9 (UTC)
    unsigned int    year __attribute__((aligned(1)));   // 12 UTC
    unsigned char   month __attribute__((aligned(1)));	// 16
    unsigned char   day __attribute__((aligned(1)));
    unsigned char   hour __attribute__((aligned(1)));
    unsigned char   min __attribute__((aligned(1)));
    unsigned char   sec __attribute__((aligned(1)));
    unsigned char   valid __attribute__((aligned(1)));  // Validity Flags
                            //  bit0 validTOW 1 = Valid Time of Week
                            //  bit1 validWKN 1 = Valid Week Number
                            //  bit2 validUTC 1 = Valid UTC (Leap Seconds already known)
} UbloxNavTimeUtcRecType __attribute__((aligned(1)));

// 高速サンプルデータ記録用データタイプ
typedef struct {
	UbloxNavTimeUtcRecType	gps;			// GPSタイムスタンプ
	unsigned char	data[AD_CHNUM][AD_SAMPLE][AD_BYTES];	// AD
} HighSampleRecType;

#define	HIGH_WRITE_LEN	szieof(HighSampleRecType)
#endif
#define	HIGH_HEADER_LEN	14
#define	HIGH_WRITE_LEN_MAX	(HIGH_HEADER_LEN + AD_CHNUM*AD_SAMPLE*AD_BYTES)
#define	HIGH_WRITE_LEN	(HIGH_HEADER_LEN + AD_CHNUM*conf_freq_get()*AD_BYTES)	// 記録周波数で変わる

int sec_file_open(FILE **fp, AdData *D);
int sec_file_out(FILE *fp, char *out, int len);
int sec_file_close(FILE *fp);
int sec_make_rec_data(AdData *ad, char *buf);

int high_file_open(FILE **fp, AdData *D);
int high_file_out(FILE *fp, char *out, int len);
int high_file_close(FILE *fp);
int high_make_rec_data(AdData *ad, char *buf);

#endif
