

#if	!defined(__RING_H__)
#define	__RING_H__

typedef struct {
	// 読み出し位置　複数設定できる
	int	*read;
	// 書き込み位置
	int	write;
	// 最新データ位置
	int	latest;
	// バッファ個数
	int	num;
	// readポインタ個数
	int	read_num;
} RING_T;

RING_T* ring_create(int read_num);
void ring_destroy(RING_T *t);
void ring_init(RING_T *t, int num);
void ring_clear(RING_T *t, int no);
int ring_read_get(RING_T *t, int no);
void ring_read_set(RING_T *t, int no, int i);
void ring_read_plus(RING_T *t, int no);
int ring_write_get(RING_T *t);
void ring_write_plus(RING_T *t);
int ring_num_get(RING_T *t, int no);
int ring_latest_get(RING_T *t);
void ring_latest_set(RING_T *t, int i);
int ring_is_full(RING_T *t, int no);

#endif
