#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
//#include <termios.h>
#include <fcntl.h>
#include <string.h>

#include "spi.h"
#include "ad_ring.h"

static int	fd_spi = -1;

int spi_get_fd(void)
{
	return fd_spi;
}
int spi_open(char *dev)
{
	fd_spi = open(dev, O_RDWR);
	return fd_spi;
}
/*
	デバイスへのioctl
*/
int spi_ioctl(int cmd, void *p)
{
	return ioctl(fd_spi, cmd, p);
}

int spi_close(void)
{
	return close(fd_spi);
}

// 送信データ長セット
void spi_tx_len_set(int len)
{
	spi_ioctl(CMD_TX_LEN, &len);
}
// 同期シリアル受信データ取得
void spi_rx_get(char *p)
{
	spi_ioctl(CMD_RX_GET, p);
}

// 同期シリアル送信データセット
void spi_tx_set(char *p)
{
	spi_ioctl(CMD_TX_SET, p);
}
// リングバッファクリア
void spi_buf_clear(void)
{
	spi_ioctl(CMD_BUF_CLEAR, NULL);
}

// リングバッファのデータ数get
int spi_dnum_get(void)
{
	int	i = 0;
	spi_ioctl(CMD_DNUM_GET, &i);
	return i;
}
// SPIで実際に受信したデータ長を取得
int spi_rcvd_len_get(void)
{
	int	i = 0;
	spi_ioctl(CMD_RECEIVED_LEN_GET, &i);
	return i;
}
// コマンド送信
void spi_cmd_send(char cmd_code, char *cmd_data, int data_len)
{
	char	cmd[SPI_CMD_LEN];
	
	memset(cmd, 0, SPI_CMD_LEN);

	cmd[SPI_CMD_OFS_HEAD] = SPI_HEAD_CHAR;
	cmd[SPI_CMD_OFS_CMDCODE] = cmd_code;

	// data
	if (data_len > (SPI_CMD_LEN - SPI_CMD_OFS_CMDDATA)) {
		data_len = SPI_CMD_LEN - SPI_CMD_OFS_CMDDATA;
	}
	memcpy(&cmd[SPI_CMD_OFS_CMDDATA], cmd_data, data_len);

	spi_tx_set(cmd);
}
// Gainコマンド送信
void spi_cmd_send_gain(int gain)
{
	char	cmd[SPI_CMD_LEN];
	int	i;
	
	memset(cmd, 0, SPI_CMD_LEN);

	for(i = 0; i < AD_CHNUM; i++)
		cmd[i] = gain;
	spi_cmd_send(SPI_CMDCODE_GAIN, cmd, AD_CHNUM);
}

