#if	!defined(__SPI_H__)
#define	__SPI_H__

// ioctlコマンド
// SPI受信データ取得
#define	CMD_RX_GET	11
// SPI送信データ長セット
#define	CMD_TX_LEN	12
// SPI送信データセット PICへのコマンド
#define	CMD_TX_SET	13
// リングバッファにあるデータ数を返す
#define	CMD_DNUM_GET	14
// リングバッファクリア
#define	CMD_BUF_CLEAR	15
// SPIで実際に受信したデータ長を取得
#define	CMD_RECEIVED_LEN_GET	20

// SPIで受信するデータ長　固定長 $含む
#define	SPI_DATA_LEN	(965)
// SPI受信データの先頭文字　送信コマンドでも使用
#define	SPI_HEAD_CHAR	'$'

// SPI受信データ　応答データ　長さ
#define	SPI_RESDATA_LEN	17

// SPI受信データ　Checksum　長さ
#define	SPI_CHECKSUM_LEN	2

// SPI受信データの先頭からのオフセット
#define	SPI_OFS_RESCODE	1
#define	SPI_OFS_RESDATA	2
#define	SPI_OFS_GPS		(19)
#define	SPI_OFS_1SEC	(39)
#define	SPI_OFS_DATA	(63)
#define	SPI_OFS_SUM		963

// SPI送信コマンド長　固定長 $含む
#define	SPI_CMD_LEN	20

// SPI送信コマンド　フィールドのオフセット位置
#define	SPI_CMD_OFS_HEAD	0
#define	SPI_CMD_OFS_CMDCODE	1
#define	SPI_CMD_OFS_CMDDATA	2

// SPIコマンドコード
#define	SPI_CMDCODE_GAIN	1

// SPIコマンドGainの設定値
#define	SPI_CMD_GAIN_1P8	0	// 1/8
#define	SPI_CMD_GAIN_1P4	1	// 1/4
#define	SPI_CMD_GAIN_1P2	2	// 1/2
#define	SPI_CMD_GAIN_1		3
#define	SPI_CMD_GAIN_2		4
#define	SPI_CMD_GAIN_4		5
#define	SPI_CMD_GAIN_8		6
#define	SPI_CMD_GAIN_16		7
#define	SPI_CMD_GAIN_32		8
#define	SPI_CMD_GAIN_64		9
#define	SPI_CMD_GAIN_128	10


int spi_get_fd(void);
int spi_open(char *dev);
int spi_ioctl(int cmd, void *p);
int spi_close(void);

void spi_tx_len_set(int len);
void spi_rx_get(char *p);
void spi_tx_set(char *p);
void spi_buf_clear(void);
int spi_dnum_get(void);
int spi_rcvd_len_get(void);

void spi_cmd_send(char cmd_code, char *cmd_data, int data_len);
void spi_cmd_send_gain(int gain);

#endif
