package jp.co.secioss.SeciossOTP;

import java.util.Date;

import org.openauthentication.otp.OneTimePasswordAlgorithm;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.Button;
import android.widget.SimpleCursorAdapter;
import android.widget.Spinner;
import android.widget.TextView;

public class SeciossOTPPasswdView extends Activity {

	public static final String PREFS_NAME = "SeciossOTPSecret";

	private Spinner mSpinner;
	private TextView mBodyText;
	private TextView mTimerText;
	private TextView mTestText;

    private SeciossOTPDbAdapter mDbHelper;
	private String mPin;
    private long mRowId;

    private Handler mHandler;

    //private String alias;
    private String secret;
    private int timez;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
    	super.onCreate(savedInstanceState);

    	setContentView(R.layout.seciossotp_passwd_view);
        setTitle(R.string.seciossotp_passwd_title2);

        mDbHelper = new SeciossOTPDbAdapter(this);
        mDbHelper.open();
        Cursor cur = mDbHelper.fetchAllSecrets();
        startManagingCursor(cur);
        SimpleCursorAdapter cursorAdapter = new SimpleCursorAdapter(this,
        		android.R.layout.simple_spinner_item,
        		cur,
        		new String[] {SeciossOTPDbAdapter.KEY_ALIAS},
        		new int[] {android.R.id.text1});
        cursorAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);

        mSpinner = (Spinner) findViewById(R.id.spinner_secret);
        mSpinner.setAdapter(cursorAdapter);
        mSpinner.setOnItemSelectedListener(new SeciossOTPSecretSelectedListener());

        mBodyText = (TextView) findViewById(R.id.seciossotp_passwd_body);
        mTimerText = (TextView) findViewById(R.id.seciossotp_passwd_timer);
        mTestText = (TextView) findViewById(R.id.test);

        Button button_create = (Button) findViewById(R.id.button_create);
        button_create.setOnClickListener(new View.OnClickListener() {
        	public void onClick(View view) {
        		createSecret();
                setResult(RESULT_OK);
            }
        });

        Bundle extras = getIntent().getExtras();
        mPin = extras != null ? extras.getString(SeciossOTPPasswd.EXTRA_PIN) : null;

		//SharedPreferences sf = getSharedPreferences(SeciossOTPTimezone.PREFS_NAME, 0);
		//timez = -12 + sf.getInt("poistion", 1);
        timez = 12;
    }

    /**
     * シークレット選択リスナー内部クラス
     */
    public class SeciossOTPSecretSelectedListener implements OnItemSelectedListener {
    	public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
        	saveState();
    		updatePasswdView();
    	}
		public void onNothingSelected(AdapterView<?> parent) {
    		// Do nothing.
    	}
    }

    @Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
    	saveState();
    	mHandler.removeCallbacks(mUpdateTimeTask);
	}

	@Override
	protected void onPause() {
		super.onPause();
		mHandler.removeCallbacks(mUpdateTimeTask);
		finish();
	}

	@Override
	protected void onResume() {
		super.onResume();
		populateFields();
	}

    /**
     * シークレットを新規する
     */
    protected void createSecret() {
        Intent i = new Intent(this, SeciossOTPSecretEdit.class);
        startActivityForResult(i, SeciossOTPSecret.ACTIVITY_CREATE);
    }

	/**
	 * 選択したシークレットを保存
	 */
	private void saveState() {
		SharedPreferences sf = getSharedPreferences(PREFS_NAME, 0);
		SharedPreferences.Editor editor = sf.edit();
		mRowId = mSpinner.getSelectedItemId();
		editor.putLong("secret", mRowId);
		editor.commit();
	}

	/**
	 * 初期表示
	 */
	private void populateFields() {
		SharedPreferences sf = getSharedPreferences(PREFS_NAME, 0);
		mRowId = sf.getLong("secret", 1);
		updatePasswdView();
	}

	/**
	 * 画面更新
	 */
	private void updatePasswdView() {
		//シークレットSpinner
		Cursor c = mDbHelper.fetchAllSecrets();
        c.moveToFirst();
        int idx = 0;
        int hasSecret = 0;
        while (!c.isAfterLast()) {
    		//alias = c.getString(c.getColumnIndexOrThrow(SeciossOTPDbAdapter.KEY_ALIAS));
    		secret = c.getString(c.getColumnIndexOrThrow(SeciossOTPDbAdapter.KEY_SECRET));

    		long rowid = c.getLong(c.getColumnIndexOrThrow(SeciossOTPDbAdapter.KEY_ROWID));
        	if (mRowId == rowid) {
        		hasSecret++;
        		break;
        	}
        	idx++;
        	c.moveToNext();
        }
        if (hasSecret > 0) {
        	mSpinner.setSelection(idx);
        }
        else {
        	mSpinner.setSelection(0);
        }

		//パスワード
		donewPassCode();

		//有効時間
		if (null != mHandler) {
			mHandler.removeCallbacks(mUpdateTimeTask);
		}
		mHandler = new Handler();
		mHandler.post(mUpdateTimeTask);
	}

	/**
	 * ワンタイムパスワード生成
	 */
	private void donewPassCode() {
		long movingFactor = ((((new Date()).getTime() / 10000) + ((timez - 12) * 360)) / 6);	//epoch
		int codeDigits = 8;
		boolean addChecksum = false;
		int truncationOffset = -1;
		String otp = OneTimePasswordAlgorithm.generateOTP(
				(secret + mPin).getBytes(), movingFactor, codeDigits, addChecksum, truncationOffset);
		mBodyText.setText(otp);
		mTestText.setText("");
	}

	/**
	 * 時間自動更新
	 */
	private Runnable mUpdateTimeTask = new Runnable() {
		public void run() {
			long dispepoch = ((new Date()).getTime() / 1000) + ((timez - 12) * 3600);
			dispepoch -= (int)(dispepoch / 60) * 60;
			dispepoch = 59 - dispepoch;

			if (dispepoch < 10) {
				mTimerText.setText("0" + dispepoch + " sec");
			}
			else {
				mTimerText.setText(dispepoch + " sec");
			}

			if (dispepoch == 59) {
				donewPassCode();
			}

			mHandler.postDelayed(mUpdateTimeTask, 1000);
		}
	};

}
