#import "NewSecret.h"
#import "CreateSecret.h"
#import "OTPAlgorithm.h"
#import "SecretKey.h"
#import "OTPAppDelegate.h"
#import "UserData.h"
#import "PinViewController.h"
#import "NewSecretSwingPage.h"
#import "OTPViewController.h"

@interface NewSecret(private)
- (void) timerFired:(NSTimer *)theTimer;
@end

@implementation NewSecret

/*
 // The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}
*/
// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	self.navigationItem.title = @"パスワード表示";
	pickerViewList = [[NSMutableArray alloc] init];
	SecretKey *secretKey = nil;
	UserData *userData = [UserData sharedManager];
	int listCnt = [userData getSecretKeyCount];
	if (listCnt != 0){
		[self takePassword:0];
		[infoLable setText:@"シークレットを選択してください。"];
	}else {
		[infoLable setText:@"まずは新しいシークレットを作成してください。"];
	}

	for (int i=0; i<listCnt; i++) {
		secretKey = [userData getSecretKey:i];
		[pickerViewList addObject:secretKey.Alias];
	}
	/*UIBarButtonItem *cancelButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"メニュー" style:UIBarButtonItemStyleBordered target:self action:@selector(back)];
    self.navigationItem.leftBarButtonItem = cancelButtonItem;
    [cancelButtonItem release];*/
	UIBarButtonItem *back = [[UIBarButtonItem alloc] init];
	back.title = @"戻る";
    self.navigationItem.backBarButtonItem = back;
    [back release];
	NSUserDefaults *defaults =[NSUserDefaults standardUserDefaults];
	NSInteger rowSelected = [defaults integerForKey:@"RowSelected"];
	[pickerView selectRow:rowSelected inComponent:0 animated:YES];
}


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
		
}

- (void)dealloc {
    [super dealloc];
}

- (IBAction)newSecretAction{
	NSUserDefaults *defaults =[NSUserDefaults standardUserDefaults];
	UserData *userData = [UserData sharedManager];
	int listCnt = [userData getSecretKeyCount];
	if (listCnt >= 100){
		NSString *msg = [[NSString alloc] initWithFormat:@"シークレット登録オーバー！\nシークレット登録が１００件を超えました。"];
		UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"シークレット入力エラー！" message:msg delegate:self cancelButtonTitle:@"はい" otherButtonTitles:nil];
		[alert show];     
		[alert release];
		[msg release];
	}else{
		[defaults setInteger:1 forKey:@"SelectedFromPage"];
		[defaults setInteger:0 forKey:@"BackPage"];
		NSInteger segState = [defaults integerForKey:@"SegState"];
		NewSecretSwingPage *secretSwing = [[NewSecretSwingPage alloc] initWithNibName:@"NewSecretSwingPage" bundle:nil];
		CreateSecret *create = [[CreateSecret alloc] initWithNibName:@"CreateSecret" bundle:nil];
		switch (segState) {
			case 1:
				[self.navigationController pushViewController:create animated:YES];
				break;
			case 0:
				[defaults setInteger:0 forKey:@"BackSecretSwing"];
				[self.navigationController pushViewController:secretSwing animated:YES];
				break;
			default:
				break;
		}
	}
}

- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView{
	return 1;
}
- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component{
	return (NSInteger)[pickerViewList count];
}
- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component{
	return [pickerViewList objectAtIndex:row];
	return @"";
}

- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component{
	[self takePassword:row];
	NSUserDefaults *defaults =[NSUserDefaults standardUserDefaults];
	[defaults setInteger:row forKey:@"RowSelected"];
}

- (void) timerFired:(NSTimer *)theTimer
{
    // update the displayed time left
    NSInteger secondsLeft   = [endAt timeIntervalSince1970] - [[NSDate date] timeIntervalSince1970];    
    // are we there yet?
    if (secondsLeft <= 0) {
		SecretKey *secretKey = nil;
		UserData *userData = [UserData sharedManager];
		secretKey = [userData getSecretKey:selectedRow];
		NSString *keystr = secretKey.Key; //入力された値の取得
		
		/*以下２行はSeciossOTPの仕様通りにmovingFactorを算出*/
		//int timez = 12; //SeciossOTPの仕様と同じくタイムゾーンをセット
		/*NSUserDefaults *defaults =[NSUserDefaults standardUserDefaults];
		NSInteger timez = [defaults integerForKey:@"TimeZone"];
		NSTimeInterval nowTime = [NSDate timeIntervalSinceReferenceDate];
		//NSTimeInterval nowTime = [NSDate timeIntervalSince1970];
		int seconds = (int)nowTime;
		long movingFactor = (((seconds / 10) + ((timez - 12) * 360)) / 6);
		*/
		//NSLog(keystr);	
	
		/*以下OTPAlgorithmをインスタンス化、OTP生成メソッドの使用*/
		OTPAlgorithm *otpa = [OTPAlgorithm new];
		int codeDigits = 8; //出力するOTPの桁数
		//NSString *secretTest = @"eee41eeeee33eeeee2ee";
		NSString *hash = [otpa generateOTP:keystr codeDigits:codeDigits];

		[passwordLable setText:hash]; 
		secondsLeft =60;
		timer = [[NSTimer scheduledTimerWithTimeInterval:1.0 target:self selector:@selector(timerFired:) userInfo:nil repeats:YES] retain];
		endAt = [[NSDate dateWithTimeIntervalSinceNow:secondsLeft] retain];
        [timeoutLable setText:@"00 sec"];
    }
	[timeoutLable setText:[NSString stringWithFormat:@"%02d sec", secondsLeft]];
}
/*- (void)back{
	PinViewController *pinView= [[PinViewController alloc]initWithNibName:@"PinViewController" bundle:nil];
	[self.navigationController pushViewController:pinView animated:NO];
}
*/
- (void)back{
	OTPViewController *otpView = [[OTPViewController alloc]initWithNibName:@"OTPViewController" bundle:nil];
	[self.navigationController pushViewController:otpView animated:NO];
}

- (void)takePassword:(NSInteger) row{
	if (row < 0){
		return;
	}
	NSInteger secondsLeft = 60;
    endAt = [[NSDate dateWithTimeIntervalSinceNow:secondsLeft] retain];    
    timer = [[NSTimer scheduledTimerWithTimeInterval:1.0 target:self selector:@selector(timerFired:) userInfo:nil repeats:YES] retain];
    // call it once now so we don't have to wait a second
    [self timerFired:timer];
	
	//**************パスワード処理**********//
	selectedRow = row;
	SecretKey *secretKey = nil;
	UserData *userData = [UserData sharedManager];
	secretKey = [userData getSecretKey:row];
	NSString *keystr = secretKey.Key; //入力された値の取得
	
	//以下２行はSeciossOTPの仕様通りにmovingFactorを算出
	/*NSUserDefaults *defaults =[NSUserDefaults standardUserDefaults];
	NSInteger timez = [defaults integerForKey:@"TimeZone"];
	//int timez = 12; //SeciossOTPの仕様と同じくタイムゾーンをセット
	NSTimeInterval nowTime = [NSDate timeIntervalSinceReferenceDate];
	int seconds = (int)nowTime;
	long movingFactor = (((seconds / 10) + ((timez - 12) * 360)) / 6);*/
	
	//以下OTPAlgorithmをインスタンス化、OTP生成メソッドの使用
	OTPAlgorithm *otpa = [OTPAlgorithm new];
	int codeDigits = 8; //出力するOTPの桁数
	//NSString *secretTest = @"eee41eeeee33eeeee2ee";

	NSString *hash = [otpa generateOTP:keystr codeDigits:codeDigits];
	
	[passwordLable setText:hash]; 
}

@end
