#import "SecretController.h"
#import "CreateSecret.h"
#import "SecretKey.h"
#import "OTPAppDelegate.h"
#import "UserData.h"
#import "OTPViewController.h"
#import "NewSecretSwingPage.h"

@implementation SecretController

/*
 // The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}
*/


// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
	self.title = @"シークレット管理";
    [super viewDidLoad];
	pickerViewList = [[NSMutableArray alloc] init];
	SecretKey *secretKey = nil;
	UserData *userData = [UserData sharedManager];
	int listCnt = [userData getSecretKeyCount];
	if (listCnt == 0){
		[infoLable setText:@"まずは新しいシークレットを作成してください。"];
		[resetSecretButton setUserInteractionEnabled:NO];
		[resetSecretButton setAlpha:0.5];
		[deleteSecretButton setUserInteractionEnabled:NO];
		[deleteSecretButton setAlpha:0.5];
	}else{
		[infoLable setText:@"シークレットを選択してください。"];
		[resetSecretButton setUserInteractionEnabled:YES];
		[resetSecretButton setAlpha:1.0];
		[deleteSecretButton setUserInteractionEnabled:YES];
		[deleteSecretButton setAlpha:1.0];
	}
	for (int i=0; i<listCnt; i++) {
		secretKey = [userData getSecretKey:i];
		[pickerViewList addObject:secretKey.Alias];
	}
	/*UIBarButtonItem *cancelButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"メニュー" style:UIBarButtonItemStyleBordered target:self action:@selector(back)];
    self.navigationItem.leftBarButtonItem = cancelButtonItem;
    [cancelButtonItem release];*/
	UIBarButtonItem *back = [[UIBarButtonItem alloc] init];
	back.title = @"戻る";
    self.navigationItem.backBarButtonItem = back;
    [back release];
	NSUserDefaults *defaults =[NSUserDefaults standardUserDefaults];
	NSInteger rowSelected = [defaults integerForKey:@"RowSelected"];
	[pickerView selectRow:rowSelected inComponent:0 animated:YES];
	
}


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}

- (void)dealloc {
    [super dealloc];
}
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView{
	return 1;
}
- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component{
	return [pickerViewList count];
}
- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component{
	return [pickerViewList objectAtIndex:row];
}
- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component{
	selectedPickerRow = row;
	NSUserDefaults *defaults =[NSUserDefaults standardUserDefaults];
	[defaults setInteger:row forKey:@"RowSelected"];
	
	
	UserData *userData = [UserData sharedManager];
	SecretKey *secretKey = nil;
	secretKey = [userData getSecretKey:row];
//	[test setText:[NSString stringWithFormat:@"%@",secretKey.Key]];
}

- (IBAction)newSecretAction{
	NSUserDefaults *defaults =[NSUserDefaults standardUserDefaults];
	UserData *userData = [UserData sharedManager];
	int listCnt = [userData getSecretKeyCount];
	if (listCnt >= 100){
		NSString *msg = [[NSString alloc] initWithFormat:@"シークレット登録オーバー！\nシークレット登録が１００件を超えました。"];
		UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"シークレット入力エラー！" message:msg delegate:self cancelButtonTitle:@"はい" otherButtonTitles:nil];
		[alert show];     
		[alert release];
		[msg release];
		selectedButton = 2;
	}else{
		[defaults setInteger:1 forKey:@"BackPage"];
		NSInteger segState = [defaults integerForKey:@"SegState"];
		CreateSecret *newSecret = [[CreateSecret alloc] initWithNibName:@"CreateSecret" bundle:nil];
		NewSecretSwingPage *secretSwing = [[NewSecretSwingPage alloc] initWithNibName:@"NewSecretSwingPage" bundle:nil];
		switch (segState) {
			case 1:
				[self.navigationController pushViewController:newSecret animated:YES];
				break;
			case 0:
				[defaults setInteger:1 forKey:@"BackSecretSwing"];
				[self.navigationController pushViewController:secretSwing animated:YES];
				break;
			default:
				break;
		}
	}
}
- (IBAction)deleteSecretAction{
	UserData *userData = [UserData sharedManager];
	int listCnt = [userData getSecretKeyCount];
	if (listCnt !=0){
		NSString *msg = [[NSString alloc] initWithFormat:@"削除しますか？"];
		UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"" message:msg delegate:self cancelButtonTitle:@"はい" otherButtonTitles:@"いいえ",nil];
		[alert show];     
		[alert release];
		[msg release];
		selectedButton = 0;
	}
}
- (IBAction)resetSecretAction{
	UserData *userData = [UserData sharedManager];
	int listCnt = [userData getSecretKeyCount];
	if (listCnt !=0){
		NSString *msg = [[NSString alloc] initWithFormat:@"リセットしますか？"];
		UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"" message:msg delegate:self cancelButtonTitle:@"はい" otherButtonTitles:@"いいえ",nil];
		[alert show];     
		[alert release];
		[msg release];
		selectedButton = 1;
	}
}
- (void) alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
	UserData *userData = [UserData sharedManager];
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	CreateSecret *newSecret = [[CreateSecret alloc] initWithNibName:@"CreateSecret" bundle:nil];
	NewSecretSwingPage *secretSwing = [[NewSecretSwingPage alloc] initWithNibName:@"NewSecretSwingPage" bundle:nil];
	//SecretController *secretController = [[SecretController alloc] initWithNibName:@"SecretController" bundle:nil];
	OTPViewController *otpView = [[OTPViewController alloc] initWithNibName:@"OTPViewController" bundle:nil];
	//if (buttonIndex ){
		//return;
		//break;
	//}else
	if (buttonIndex == 0){ // はい
		//error = FALSE;
		[defaults setInteger:1 forKey:@"BackSecretSwing"];
		switch (selectedButton) {
			case 0: // 削除
				if ([userData getSecretKeyCount] != 0){
					[userData removeSecretData:[userData getSecretKey:selectedPickerRow] index:selectedPickerRow];//選択されているシークレットを削除する
					//[userData removeSecretData:[userData getSecretKey:0] index:0];//トップのシークレットを削除する
					[defaults setInteger:[userData getSecretKeyCount] forKey:@"ALIAS_NUMBER"];
					//[self.navigationController pushViewController:secretController animated:NO];
					[defaults setBool:TRUE forKey:@"DelateBack"];
					[self.navigationController pushViewController:otpView animated:NO];
				}
				break;
			case 1: // リセット
				if ([userData getSecretKeyCount] != 0){
					//[userData resetSecretData:[userData getSecretKey:selectedPickerRow] index:selectedPickerRow];//選択されているシークレットをリセットする
					[defaults setInteger:[userData getSecretKeyCount] forKey:@"ALIAS_NUMBER"];//選択されているRowを保存する
					//[userData resetSecretData:[userData getSecretKey:0] index:0];//トップをリセットする
					//[defaults setInteger:0 forKey:@"ALIAS_NUMBER"];//トップを保存する
					[defaults setInteger:1 forKey:@"BackPage"];
					[defaults setInteger:selectedPickerRow forKey:@"ResetPickerRow"];
					[defaults setBool:TRUE forKey:@"RESETED"];
					NSInteger segState = [defaults integerForKey:@"SegState"];
					switch (segState) {
						case 1:
							[self.navigationController pushViewController:newSecret animated:YES];
							break;
						case 0:
							[self.navigationController pushViewController:secretSwing animated:YES];
							break;
						default:
							break;
					}					
				}
				break;
			default:
				break;
		}
	}
}
/*- (void)back{
	OTPViewController *otpView = [[OTPViewController alloc] initWithNibName:@"OTPViewController" bundle:nil];
	[self.navigationController pushViewController:otpView animated:NO];
}
*/
/*- (void)back{
	OTPViewController *otpView = [[OTPViewController alloc] initWithNibName:@"OTPViewController" bundle:nil];
	[self.navigationController pushViewController:otpView animated:NO];
}*/

@end
