﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#include "DummyWindow.h"

// Windows headers
#include <Winuser.h>

namespace bearmini
{
    ///  ダミーウインドウのハンドル
    ::HWND DummyWindow::s_hWnd = 0;

    ///  タイトル バーのテキスト
    wchar_t DummyWindow::s_title[100] = L"SendToCMD dummy window";

    ///  メイン ウィンドウ クラス名
    wchar_t DummyWindow::s_windowClass[100] = L"SendToCMD dummy window class";


    ///
    ///  ダミーウインドウ用のウインドウプロシージャ
    ///
    ::LRESULT CALLBACK WndProc(::HWND hWnd, ::UINT message, ::WPARAM wParam, ::LPARAM lParam)
    {
        return ::DefWindowProc(hWnd, message, wParam, lParam);
    }

    ///
    ///  ダミーウインドウをセットアップします。
    ///
    void DummyWindow::Setup(::HINSTANCE hInstance)
    {
        if (s_hWnd != 0)
        {
            throw std::exception("DummyWindow is already initialized.");
        }

        registerMyWindowClass(hInstance);

        ::HMENU hDummyMainMenu = ::CreateMenu();

        s_hWnd = ::CreateWindowW(
            s_windowClass, 
            s_title, 
            WS_OVERLAPPEDWINDOW, 
            CW_USEDEFAULT, 
            0, 
            CW_USEDEFAULT, 
            0, 
            0, 
            hDummyMainMenu, 
            hInstance, 
            0
        );
    }


    ///
    ///  ダミーウインドウを解放します。
    ///
    void DummyWindow::Teardown()
    {
        ::DestroyWindow(s_hWnd);
        s_hWnd = 0;
    }


    ///
    ///  ダミーウインドウのウインドウクラスを Windows に登録します。
    ///
    ::ATOM DummyWindow::registerMyWindowClass(::HINSTANCE hInstance)
    {
        ::WNDCLASSEX wcex;

        wcex.cbSize = sizeof(::WNDCLASSEX); 

        wcex.style          = CS_HREDRAW | CS_VREDRAW;
        wcex.lpfnWndProc    = WndProc;
        wcex.cbClsExtra     = 0;
        wcex.cbWndExtra     = 0;
        wcex.hInstance      = hInstance;
        wcex.hIcon          = 0;
        wcex.hCursor        = ::LoadCursor(0, IDC_ARROW);
        wcex.hbrBackground  = (HBRUSH)(COLOR_WINDOW+1);
        wcex.lpszMenuName   = 0;
        wcex.lpszClassName  = s_windowClass;
        wcex.hIconSm        = 0;

        return ::RegisterClassEx(&wcex);
    }


}
