﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

// private headers
#include "BehaviorSetting.h"


namespace bearmini
{
    class EffectiveBehavior
    {
    public:
        EffectiveBehavior(const std::wstring& commandLine, bool autoExec, unsigned int cursorPosition);
        virtual ~EffectiveBehavior() throw();

        static EffectiveBehavior CreateFrom(const BehaviorSetting& behaviorSetting, const std::wstring& path);
        static EffectiveBehavior CreateForCygwinFrom(const BehaviorSetting& behaviorSetting, const std::wstring& path);

        std::wstring CommandLine() const { return m_commandLine; }
        bool DoesAutoExec() const { return m_autoExec; }
        int CursorPosition() const { return m_cursorPosition; }

    private:
        static std::wstring replaceSpecialCharacters(const std::wstring& line, const std::wstring& path, bool bEscapeBackslash = false);

    private:
        std::wstring m_commandLine;
        bool m_autoExec;
        int m_cursorPosition;
    };

}