﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#include "Program.h"

#include "Path.h"
#include "SendToCMD.h"
#include "SendToCygwin.h"
#include "SendToPowerShell.h"


namespace bearmini
{

    ///
    ///  プログラムを実行するためのインスタンスを作成します。
    ///   SendToCMD を実行するか、SendToCygwin を実行するか、それとも SendToPS を実行するか、
    ///   を選択するためのファクトリメソッドです。
    ///
    Program* Program::Create()
    {
        std::wstring exeFileName(getExeFileNameWithoutExt());

        if (SendToCMD::IsMyExeName(exeFileName))
        {
            return new SendToCMD();
        }
        else if (SendToCygwin::IsMyExeName(exeFileName))
        {
            return new SendToCygwin();
        }
        else if (SendToPowerShell::IsMyExeName(exeFileName))
        {
            return new SendToPowerShell();
        }
        else
        {
            throw std::exception("実行ファイル名が書き換えられています.");
        }
    }


    ///
    ///  プログラムの実行ファイル名（拡張子なし）を取得します。
    ///
    std::wstring Program::getExeFileNameWithoutExt()
    {
        // 実行ファイルの名前を得る
        wchar_t exepath[_MAX_PATH];
        ::GetModuleFileNameW(0, exepath, _MAX_PATH);
        
        return Path::GetFileNameWithoutExtension(exepath);
    }

}
