﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#include "EffectiveBehaviorTest.h"

#include <cppunit/TestAssert.h>

#include "BehaviorSetting.h"
#include "EffectiveBehavior.h"
#include "UnitTestUtil.h"


namespace bearmini
{
    //CPPUNIT_REGISTRY_ADD_TO_DEFAULT(EffectiveBehaviorTest);
    CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(EffectiveBehaviorTest, "EffectiveBehaviorTest");
    CPPUNIT_TEST_SUITE_REGISTRATION(EffectiveBehaviorTest);

    
    ///
    ///  CreateFrom() をテストします。
    ///  
    ///
    void EffectiveBehaviorTest::test_CreateFrom()
    {
        bearmini::EffectiveBehavior eb = bearmini::EffectiveBehavior::CreateFrom(
            bearmini::BehaviorSetting(L"dummy_caption", L"%F", false), 
            L"C:\\path\\to\\file.ext"
        );

		CPPUNIT_ASSERT_EQUALS_WSTRING(L"file.ext", eb.CommandLine());
    }

}
