﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#include "Messagebox.h"

#include "Path.h"
#include "Program.h"

namespace bearmini
{
    ///
    ///  message で指定されたメッセージを表示します。
    ///
    ///  @param[in] message 表示したいメッセージ。ASCII 文字列。
    ///
    void MessageBox::Show(const std::string& message)
    {
        ::MessageBoxA(0, message.c_str(), 0, MB_OK);
    }


    ///
    ///  message で指定されたメッセージを表示します。
    ///
    ///  @param[in] message 表示したいメッセージ。ワイド文字列。
    ///
    void MessageBox::Show(const std::wstring& message)
    {
        wchar_t lpszModuleName[_MAX_PATH];
        ::GetModuleFileNameW(0, lpszModuleName, _MAX_PATH);

        ::MessageBoxW(0, message.c_str(), Path::GetFileNameWithoutExtension(lpszModuleName).c_str(), MB_OK);
    }


    ///
    ///  program で指定されたプログラムからのメッセージとして、
    ///  message で指定されたメッセージを表示します。
    ///
    ///  @param[in] program このプログラムの名前が、メッセージボックスのタイトルとして表示されます。
    ///  @param[in] message 表示したいメッセージ。ワイド文字列。
    ///
    void MessageBox::Show(const Program* program, const std::wstring& message)
    {
        ::MessageBoxW(0, message.c_str(), program->GetUserFriendlyName().c_str(), MB_OK);
    }


    ///
    ///  program で指定されたプログラムからのメッセージとして、
    ///  message で指定されたメッセージを表示します。
    ///
    ///  @param[in] program このプログラムの名前が、メッセージボックスのタイトルとして表示されます。
    ///  @param[in] message 表示したいメッセージ。ワイド文字列。
    ///  @param[in] type    メッセージボックスの種類。
    ///
    ///  @return    メッセージボックスの結果。この値によって、どのボタンが押されたかがわかります。
    ///
    DialogResult MessageBox::Show(const Program* program, const std::wstring& message, const MessageBoxType type)
    {
        return (DialogResult)::MessageBoxW(0, message.c_str(), program->GetUserFriendlyName().c_str(), type);
    }

}