﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#include "SystemInfo.h"


namespace bearmini
{
    ///
    ///  OS が 32bit バージョンか 64bit バージョンかを判定します。
    ///  このバイナリ自身が 32bit か 64bit かを判定しているわけではない、ということに注意。
    ///
    bool SystemInfo::IsPlatform32bit()
    {
    #if defined(_WIN64)
        // 64bit バイナリは 32bit OS 上では動作しないので、
        // このバイナリ自体が 64bit でコンパイルされていたら、
        // OS も 64bit に決まっている（128bit OS とかが出てこない限り）
        return false;
    #elif defined(_WIN32)
        // 32bit バイナリは 32bit OS 上でも 64bit OS 上 (Wow64) でも実行できるので、
        // このバイナリ自体が 32bit でコンパイルされていたら、
        // OS が 32bit か 64bit かを判定しないといけない
        BOOL isWow64 = FALSE;
        BOOL result = ::IsWow64Process(::GetCurrentProcess(), &isWow64);
        if (result == 0)
        {
            return false;
        }
        return (isWow64 != TRUE);
    #else
        return false;
    #endif
    }


    ///
    ///  OS が 32bit バージョンか 64bit バージョンかを判定します。
    ///  このバイナリ自身が 32bit か 64bit かを判定しているわけではない、ということに注意。
    ///
    bool SystemInfo::IsPlatform64bit()
    {
    #if defined(_WIN64)
        // 64bit バイナリは 32bit OS 上では動作しないので、
        // このバイナリ自体が 64bit でコンパイルされていたら、
        // OS も 64bit に決まっている（128bit OS とかが出てこない限り）
        return true;
    #elif defined(_WIN32)
        // 32bit バイナリは 32bit OS 上でも 64bit OS 上 (Wow64) でも実行できるので、
        // このバイナリ自体が 32bit でコンパイルされていたら、
        // OS が 32bit か 64bit かを判定しないといけない
        BOOL isWow64 = FALSE;
        BOOL result = ::IsWow64Process(::GetCurrentProcess(), &isWow64);
        if (result == 0)
        {
            return false;
        }
        return (isWow64 == TRUE);
    #else
        return false;
    #endif
    }


    ///
    ///  Windows のシステムディレクトリを取得します。
    ///  このディレクトリは通常 C:\Windows\System32 です。
    ///
    std::wstring SystemInfo::GetSystemDir()
    {
        wchar_t buf[_MAX_PATH];
        ::UINT result = ::GetSystemDirectoryW(buf, _MAX_PATH);
        if (result == 0)
        {
            throw std::exception("GetSystemDirectoryW() failed.");
        }

        return buf;
    }


    ///
    ///  Windows のメジャーバージョンを取得します。
    ///
    int SystemInfo::GetOsMajorVersion()
    {
        ::OSVERSIONINFO versionInfo = { 0 };
        versionInfo.dwOSVersionInfoSize = sizeof(versionInfo);

        ::GetVersionExW(&versionInfo);

        return versionInfo.dwMajorVersion;
    }
}