﻿Write-Host " ========== ステップ 1 ========== "
Write-Host " パラメータを収集 ... "
# 必須パラメータは リソースファイル用バージョン、ドキュメント用バージョン、アーカイブファイル名用バージョン
# リソースファイル用バージョンは、    "1,2,3,4"
# ドキュメント用バージョンは、        "1.2.3 beta 4"
# アーカイブファイル名用バージョンは  "1.2.3b4"
# というような形式で指定してください。

if ($args.Length -ne 3)
{
    Write-Host $args
    Write-Host "Usage : "
    Write-Host "        PS > & MakeReleasePackage.ps1 <version for resource > <version for readme.txt> <version for archive file name>"
    return
}

$VersionForResource = $args[0]
$VersionForDocument = $args[1]
$VersionForArchiveFile = $args[2]


Write-Host " ========== ステップ 2 ========== "
Write-Host " パラメータをチェック ... "
function checkParameters([string]$verRes, [string]$verDoc, [string]$verZip)
{
    
}
checkParameters $VersionForResource $VersionForDocument $VersionForArchiveFile


Write-Host " ========== ステップ 3 ========== "
Write-Host " 必要な情報を準備 ... "
$SolutionDir = (Resolve-Path ..).ToString()


Write-Host " ========== ステップ 4 ========== "
Write-Host " バージョンリソースを書き換え ... "
$RcFile = [IO.Path]::Combine($SolutionDir, "src\Main\SendToCMD.rc")
$TempRcFile = [IO.Path]::Combine($SolutionDir, "src\Main\Temp.rc")
$RcFileBackup = [IO.Path]::Combine($SolutionDir, "src\Main\SendToCMD.rc.bak")

function ReplaceVersionInResourceFile()
{
    $ContentOfRcFile = Get-Content $RcFile
    foreach($line in $ContentOfRcFile) 
    {
        if ($line -match ".*FILEVERSION \d,\d,\d,\d")
        {
            $line = [Text.RegularExpressions.Regex]::Replace($line, "(.*)FILEVERSION \d,\d,\d,\d", "`$1FILEVERSION $VersionForResource")
        }
        elseif ($line -match ".*PRODUCTVERSION \d,\d,\d,\d")
        {
            $line = [Text.RegularExpressions.Regex]::Replace($line, "(.*)PRODUCTVERSION \d,\d,\d,\d", "`$1PRODUCTVERSION $VersionForResource")
        }
        elseif ($line -match "VALUE `"FileVersion`", `"\d,\s*\d,\s*\d,\s*\d`"")
        {
            $line = [Text.RegularExpressions.Regex]::Replace($line, "(.*)VALUE `"FileVersion`", `"\d,\s*\d,\s*\d,\s*\d`"", "`$1VALUE `"FileVersion`", `"$VersionForResource`"")
        }
        elseif ($line -match "VALUE `"ProductVersion`", `"\d,\s*\d,\s*\d,\s*\d`"")
        {
            $line = [Text.RegularExpressions.Regex]::Replace($line, "(.*)VALUE `"ProductVersion`", `"\d,\s*\d,\s*\d,\s*\d`"", "`$1VALUE `"ProductVersion`", `"$VersionForResource`"")
        }
        
        $line
    }
}
ReplaceVersionInResourceFile > $TempRcFile

Move-Item -path $RcFile -destination $RcFileBackup -force
Move-Item -path $TempRcFile -destination $RcFile


Write-Host " ========== ステップ 5 ========== "
Write-Host " リビルドを実行 ... "
& .\RebuildAll.ps1


Write-Host " ========== ステップ 6 ========== "
Write-Host " ドキュメントを書き換え ... "
$ReadMeFile = [IO.Path]::Combine($SolutionDir, "doc\ReadMe.txt")
$OutReadMeFileWin32 = [IO.Path]::Combine($SolutionDir, "build\package\Win32\ReadMe.txt")
$OutReadMeFileX64   = [IO.Path]::Combine($SolutionDir, "build\package\x64\ReadMe.txt")
New-Item -path ([IO.Path]::Combine($SolutionDir, "build\package\Win32\")) -force -itemType "directory" > $null
New-Item -path ([IO.Path]::Combine($SolutionDir, "build\package\x64\")) -force -itemType "directory" > $null

function ReplaceVersionInReadMeFile()
{
    $ContentOfReadMeFile = Get-Content $ReadMeFile
    foreach($line in $ContentOfReadMeFile) 
    {
        if ($line -match ".*<%version string placeholder%>")
        {
            $line = [Text.RegularExpressions.Regex]::Replace($line, "(.*)<%version string placeholder%>", "`$1 $VersionForDocument")
        }
        
        $line
    }
}

ReplaceVersionInReadMeFile > $OutReadMeFileWin32
ReplaceVersionInReadMeFile > $OutReadMeFileX64


Write-Host " ========== ステップ 7 ========== "
Write-Host " ファイルを収集 ... "
$ArtifactDir32 = [IO.Path]::Combine($SolutionDir, "build\Win32\Release\Main\")
$ArtifactDir64 = [IO.Path]::Combine($SolutionDir, "build\x64\Release\Main\")

$TargetDir32   = [IO.Path]::Combine($SolutionDir, "build\package\Win32\")
$TargetDir64   = [IO.Path]::Combine($SolutionDir, "build\package\x64\")

function GetArtifact32()
{
    [IO.Path]::Combine($ArtifactDir32, "SendToCMD.exe")
    [IO.Path]::Combine($ArtifactDir32, "SendToCMD.ini")
    [IO.Path]::Combine($ArtifactDir32, "SendToCygwin.exe")
    [IO.Path]::Combine($ArtifactDir32, "SendToCygwin.ini")
    [IO.Path]::Combine($ArtifactDir32, "SendToPS.exe")
    [IO.Path]::Combine($ArtifactDir32, "SendToPS.ini")
}

function GetArtifact64()
{
    [IO.Path]::Combine($ArtifactDir64, "SendToCMD.exe")
    [IO.Path]::Combine($ArtifactDir64, "SendToCMD.ini")
    [IO.Path]::Combine($ArtifactDir64, "SendToCygwin.exe")
    [IO.Path]::Combine($ArtifactDir64, "SendToCygwin.ini")
    [IO.Path]::Combine($ArtifactDir64, "SendToPS.exe")
    [IO.Path]::Combine($ArtifactDir64, "SendToPS.ini")
}

$Artifact32 = GetArtifact32
$Artifact64 = GetArtifact64

Copy-Item -path $Artifact32 -destination $TargetDir32
Copy-Item -path $Artifact64 -destination $TargetDir64


Write-Host " ========== ステップ 8 ========== "
Write-Host " アーカイブ ... "

# This function is from 
# http://blogs.msdn.com/daiken/archive/2007/02/12/compress-files-with-windows-powershell-then-package-a-windows-vista-sidebar-gadget.aspx
# Thanks, David Aiken
function Add-Zip
{
    param([string]$zipfilename)

    if(-not (test-path($zipfilename)))
    {
        set-content $zipfilename ("PK" + [char]5 + [char]6 + ("$([char]0)" * 18))
        (dir $zipfilename).IsReadOnly = $false    
    }
    
    $shellApplication = new-object -com shell.application
    $zipPackage = $shellApplication.NameSpace($zipfilename)
    
    foreach($file in $input) 
    {
            $zipPackage.CopyHere($file.FullName)
            Start-sleep -milliseconds 500
    }
}

$BuildDir = [IO.Path]::Combine($SolutionDir, "build")
$PackageDir = [IO.Path]::Combine($BuildDir, "package")

$ArchiveFile32 = [IO.Path]::Combine($PackageDir, ("SendToCMD-x86-" + $VersionForArchiveFile + ".zip"))
$ArchiveFile64 = [IO.Path]::Combine($PackageDir, ("SendToCMD-x64-" + $VersionForArchiveFile + ".zip"))

Remove-Item $ArchiveFile32
Remove-Item $ArchiveFile64

$TargetFiles32 = (ls $TargetDir32)
$TargetFiles64 = (ls $TargetDir64)

$TargetFiles32 | Add-Zip $ArchiveFile32
$TargetFiles64 | Add-Zip $ArchiveFile64


Write-Host " 完了！ " -ForegroundColor Cyan
