/*
  Copyright 2008 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once


namespace bearmini
{
    ///
    ///  Iɐ\ȌŒ蒷̔zNXłB
    ///
    template<typename T>
    class FixedLengthArray
    {
    public:
        typedef std::size_t size_type;

        FixedLengthArray(size_type size, T initialValue) :
            m_pValue(0)
        {
            m_pValue = new T[size];
            for (size_type i = 0; i < size; ++i)
            {
                m_pValue[i] = initialValue;
            }
        }
        
        ~FixedLengthArray() throw()
        {
            delete[] m_pValue;
        }

        T* get()
        {
            return m_pValue;
        }

    private:
        T* m_pValue;
    };

}
