﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

#include "Foundation.h"


namespace bearmini
{
    ///
    ///  ファイル名やパスを扱うためのクラスです。
    ///
    class Path
    {
    public:
        static std::wstring GetDirectory(const std::wstring& path);
        static std::wstring GetDirectoryWithoutDrive(const std::wstring& path);
        static std::wstring GetFileName(const std::wstring& path);
        static std::wstring GetFileNameWithoutExtension(const std::wstring& path);
        static std::wstring GetExtension(const std::wstring& path);
        static std::wstring GetExtensionWithoutDot(const std::wstring& path);
        static std::wstring GetDrive(const std::wstring& path);
        static std::wstring GetDriveWithoutColon(const std::wstring& path);
        static std::wstring ChangeExtension(const std::wstring& path, const std::wstring& newExt);
        static std::wstring AddBackslash(const std::wstring& path);
		static std::wstring RemoveTrailingBackslash(const std::wstring& path);
		static std::wstring Unquote(const std::wstring& path);
        static std::wstring Combine(const std::wstring& dir, const std::wstring& file);

        static bool IsDirectory(const std::wstring& path);
        static bool IsUNC(const std::wstring& path);

    private:
        Path();
        ~Path();
    };

}
