/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

// Windows headers
#include <shlobj.h>

// private headers
#include "Uncopyable.h"


namespace bearmini
{
    ///
    ///  C++ ̃XR[v𗘗pāACOM CȕiCoInitializejƉiCoUninitializej
    ///  Iɍs߂̃NXłB
    /// 
    ///  ʏ CoInitialize()  CoUninitialize() ͕KyAŌĂяoKvAA
    ///  eXbhƂɏEsKv܂B
    ///  iCOM Cu͓IɎQƃJE^̂悤Ȃ̂Ă悤ŁA
    ///    ۂɃ͍̂Ō CoUninitialize() Ă̂悤łBj
    ///
    ///  ̂悤ȗRACOM CugpꍇAȂׂǏIɁA
    ///  COM Cu̎gp҂̎ȐӔC COM CȕƉsׂłB
    ///  
    ///  C++ ̃XR[v𗘗pĂ̂悤ȏƉȂׂIɍs߂̃NXłB
    ///
    class ScopedComLibrary : private Uncopyable
    {
    public:
        ScopedComLibrary()
        {
            ::HRESULT hr = ::CoInitialize(0);
            if (FAILED(hr))
            {
                throw std::domain_error("CoInitialize() failed.");
            }
        }

        ~ScopedComLibrary() throw()
        {
            ::CoUninitialize();
        }
    };

}
