package noguchi.SentenceLearner;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.util.Log;
import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;

class DatabaseHelper extends SQLiteOpenHelper {

	public DatabaseHelper(Context context) {
		super(context, "SentenceLearner", null, 1);
	}

	@Override
	public void onCreate(SQLiteDatabase db) {

		db.beginTransaction();
		try {
			// create categories table
			db.execSQL("create table sounds (" +
					"fileName text primary key," +
					"soundName text," +
			"isInitialise integer); ");

			// create questions table
			db.execSQL("create table questions (" +
					"qid integer primary key, " +
					"fileName text, " +
					"qString text, " +
					"aString text, " +
					"qStart integer, " +
					"qEnd integer, " +
					"aStart integer, " +
					"aEnd integer, " +
			"rating integer);");

			db.setTransactionSuccessful();
		} catch (Exception ex)
		{
			Log.v("ERROR", "DB creation failed");
		} finally {
			db.endTransaction();
		}
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		db.execSQL("drop table if exists sounds");
		db.execSQL("drop table if exists questions");
		onCreate(db);
	}

	public void insertSounds(List<SoundItem> items, SQLiteDatabase db) throws Exception{
		SQLiteStatement stmt;
		db.beginTransaction();
		try {
			// Insert into sounds table
			stmt = db.compileStatement("insert into sounds values (?, ?, ?);");
			for (SoundItem item : items) {
				stmt.bindString(1, item.getFileName());
				stmt.bindString(2, item.getName());
				stmt.bindLong(3, item.IsInitialise());
				stmt.executeInsert();
			}
			db.setTransactionSuccessful();
		} catch (Exception ex)
		{
			Log.v("ERROR", "Inert sounds failed");
			throw ex;
		} finally {
			db.endTransaction();
		}
	}

	public List<ListItem> getSounds(SQLiteDatabase db) throws Exception{
		try {
			// select sounds table
			String sqlStr = 
				"select fileName, soundName, isInitialise " +
				" from sounds ";
			Cursor c = db.rawQuery(sqlStr, null);	
			c.moveToFirst();
			List<ListItem> list = new ArrayList<ListItem>();
			for (int i = 0; i < c.getCount(); i++) {
				SoundItem item = new SoundItem();
				item.setFileName(c.getString(0));
				item.setInitialise((int)c.getLong(2));

				// Note that IsInitialised is used to find the location
				// It is used in the different purpose as what was decided in the design at first.
				if (item.IsInitialise() == 2)
				{
					item.setName("* " + c.getString(1));
				}
				else
				{
					item.setName(c.getString(1));					
				}
				list.add(item);
				c.moveToNext();
			}
			c.close();
			return list;
		} 
		catch (Exception ex)
		{
			Log.v("ERROR", "Select sounds failed");
			throw ex;
		}
	}

	public ListItem getSoundItem(String fileName, SQLiteDatabase db) throws Exception{
		try {
			// select sounds table (assume that only one element returned because fileName is a key.
			String sqlStr = 
				"select fileName, soundName, isInitialise " +
				" from sounds " +
				" where fileName = '" + fileName + "'";
			Cursor c = db.rawQuery(sqlStr, null);	
			c.moveToFirst();
			SoundItem item = new SoundItem();
			item.setFileName(c.getString(0));
			item.setName(c.getString(1));
			item.setInitialise((int)c.getLong(2));
			c.close();
			return item;
		} 
		catch (Exception ex)
		{
			Log.v("ERROR", "Select soundItem failed");
			throw ex;
		}
	}

	public void updateSoundItem(SoundItem item, SQLiteDatabase db) throws Exception{

		String sqlStr = "update sounds set " + 
		" soundName = '" + item.getName() + "'," +
		" isInitialise = " + item.IsInitialise() +
		" where fileName = '" + item.getFileName() + "'";

		db.execSQL(sqlStr);
	}

	public void updateSoundItemIsInitialise(SoundItem item, SQLiteDatabase db) throws Exception{

		String sqlStr = "update sounds set " + 
		" isInitialise = " + item.IsInitialise() +
		" where fileName = '" + item.getFileName() + "'";

		db.execSQL(sqlStr);
	}

	public void insertQuestions(List<QuestionItem> items, SQLiteDatabase db) throws Exception{
		SQLiteStatement stmt;
		db.beginTransaction();
		try {
			// Insert into questions table
			stmt = db.compileStatement("insert into questions values (?, ?, ?, ?, ?, ?, ?, ?, ?);");
			for (QuestionItem item : items) {
				stmt.bindNull(1);
				stmt.bindString(2, item.getSoundFileName());
				stmt.bindString(3, item.getName());
				stmt.bindString(4, item.getAnswer());
				stmt.bindLong(5, item.getQuestionStartTime());
				stmt.bindLong(6, item.getAnswerStartTime());
				stmt.bindLong(7, item.getAnswerStartTime());
				stmt.bindLong(8, item.getEndTime());
				stmt.bindLong(9, item.getRating());
				stmt.executeInsert();
			}
			db.setTransactionSuccessful();
		} catch (Exception ex)
		{
			Log.v("ERROR", "Inert questions failed");
			throw ex;
		} finally {
			db.endTransaction();
		}
	}

	public void deleteQuestionsBySoundFileName(String soundFileName, SQLiteDatabase db) throws Exception{
		SQLiteStatement stmt;
		db.beginTransaction();
		try 
		{
			// Delete questions table
			stmt = db.compileStatement("delete from questions where fileName = '" + soundFileName + "';");
			stmt.execute();
			db.setTransactionSuccessful();
		} 
		catch (Exception ex)
		{
			Log.v("ERROR", "Delete questions failed");
			throw ex;
		} 
		finally 
		{
			db.endTransaction();
		}
	}

	public void updateQuestionsList(String soundFileName, List<QuestionItem> items, SQLiteDatabase db)
	throws Exception {
		SQLiteStatement stmt;
		db.beginTransaction();
		try {
			// delete questions once
			stmt = db.compileStatement("delete from questions where fileName = '" + soundFileName + "';");
			stmt.execute();

			// Insert into questions table
			stmt = db.compileStatement("insert into questions values (?, ?, ?, ?, ?, ?, ?, ?, ?);");
			for (QuestionItem item : items) {
				stmt.bindNull(1);
				stmt.bindString(2, item.getSoundFileName());
				stmt.bindString(3, item.getName());
				stmt.bindString(4, item.getAnswer());
				stmt.bindLong(5, item.getQuestionStartTime());
				stmt.bindLong(6, item.getAnswerStartTime());
				stmt.bindLong(7, item.getAnswerStartTime());
				stmt.bindLong(8, item.getEndTime());
				stmt.bindLong(9, item.getRating());
				stmt.executeInsert();
			}
			db.setTransactionSuccessful();
		} 
		catch (Exception ex)
		{
			Log.v("ERROR", "Inert questions failed");
			throw ex;
		} 
		finally 
		{
			db.endTransaction();
		}
	}

	public List<QuestionItem> getQuestions(SQLiteDatabase db, String soundFileName, int baseRating) throws Exception{
		try {			
			// select question table
			String sqlStr = 
				"select " +
				" questions.fileName, " +
				" questions.qString, " + 
				" questions.aString, " +
				" questions.qStart, " +
				" questions.aStart, " +
				" questions.aEnd, " + 
				" questions.rating, " +
				" sounds.soundName " +
				" from questions, sounds" +
				" where questions.fileName = '" + soundFileName + "'" + 
				" and questions.fileName = sounds.fileName" +
				" and rating >= " + baseRating;
			
			Cursor c = db.rawQuery(sqlStr, null);	
			c.moveToFirst();
			List<QuestionItem> list = new ArrayList<QuestionItem>();
			for (int i = 0; i < c.getCount(); i++) {
				QuestionItem item = new QuestionItem();

				item.setSoundFileName(c.getString(0));
				item.setName(c.getString(1));
				item.setAnswer(c.getString(2));
				item.setQuestionStartTime(c.getInt(3));
				item.setAnswerStartTime(c.getInt(4));
				item.setEndTime(c.getInt(5));
				item.setRating(c.getInt(6));
				item.setSoundName(c.getString(7));

				list.add(item);
				c.moveToNext();
			}
			c.close();
			return list;
		} 
		catch (Exception ex)
		{
			Log.v("ERROR", "Select questions failed");
			throw ex;
		}
	}

	public void updateQuestionItem(QuestionItem item, SQLiteDatabase db) throws Exception{
		//TODO
		//String sqlStr = "update sounds set " + 
		//" soundName = '" + item.getName() + "'," +
		//" isInitialise = " + item.IsInitialise() +
		//" where fileName = '" + item.getFileName() + "'";
		//db.execSQL(sqlStr);
	}

	public void updateQuestionItemRating(QuestionItem item, SQLiteDatabase db) throws Exception{
		String sqlStr = "update questions set " + 
		" rating = " + item.getRating() +
		" where qString = '" + item.getName() + "'" +
		" and fileName = '" + item.getSoundFileName() + "'";
		db.execSQL(sqlStr);
	}

	public void ExportData(SQLiteDatabase db, String exportFolder) throws IOException
	{
		// Export sound table
		FileWriter fw = new FileWriter(exportFolder.toString() + "SentenceLearner_sound.csv");
		CSVWriter writer = new CSVWriter(fw, ',');

		String sqlStr = 
			"select fileName, soundName, isInitialise from sounds ";
		Cursor c = db.rawQuery(sqlStr, null);

		c.moveToFirst();
		ArrayList<String> entries = null;

		for (int i = 0; i < c.getCount(); i++) {

			entries =new ArrayList<String>();
			for (int j = 0 ; j < c.getColumnCount() ; j++)
			{
				String tmp = c.getString(j);
				entries.add(tmp);
			}

			String[] s = (String[]) entries.toArray(new String[0]);
			writer.writeNext(s);
			c.moveToNext();
		}
		c.close();
		writer.close();
		
		// Export Questions table
		fw = new FileWriter(exportFolder.toString() + "SentenceLearner_questions.csv");
		writer = new CSVWriter(fw, ',');

		sqlStr = 
			"select " +
			" questions.fileName, " +
			" questions.qString, " + 
			" questions.aString, " +
			" questions.qStart, " +
			" questions.qEnd, " +
			" questions.aStart, " +
			" questions.aEnd, " + 
			" questions.rating " +
			" from questions";

		c = db.rawQuery(sqlStr, null);

		c.moveToFirst();
		entries = null;

		for (int i = 0; i < c.getCount(); i++) {

			entries =new ArrayList<String>();
			for (int j = 0 ; j < c.getColumnCount() ; j++)
			{
				String tmp = c.getString(j);
				entries.add(tmp);
			}

			String[] s = (String[]) entries.toArray(new String[0]);
			writer.writeNext(s);
			c.moveToNext();
		}
		c.close();
		writer.close();
	}
	
	public void ImportData(SQLiteDatabase db, String importFolder) throws Exception
	{		
		// Begin transaction
		db.beginTransaction();
		
		// Delete all data at first
		SQLiteStatement stmt1 = db.compileStatement("delete from sounds;");
		SQLiteStatement stmt2 = db.compileStatement("delete from questions;");
		
		stmt1.execute();
		stmt2.execute();
		
		// Read from file
		try{		
			CSVReader lr1 = new CSVReader (new InputStreamReader(
							new FileInputStream(importFolder.toString() + "SentenceLearner_sound.csv")
							,"UTF-8"));
			CSVReader lr2 = new CSVReader (new InputStreamReader(
					new FileInputStream(importFolder.toString() + "SentenceLearner_questions.csv")
					,"UTF-8"));

			String[] columns;
			
			SQLiteStatement stmt3 = db.compileStatement("insert into sounds values (?, ?, ?);");

			while((columns = lr1.readNext())!= null){
				// Insert into sounds table
				stmt3.bindString(1, columns[0]); //fileName
				stmt3.bindString(2, columns[1]); //soundName
				stmt3.bindLong(3, Integer.parseInt(columns[2])); //isInitialise
				stmt3.executeInsert();				
			}

			SQLiteStatement stmt4 = db.compileStatement("insert into questions values (?, ?, ?, ?, ?, ?, ?, ?, ?);");
			
			while((columns = lr2.readNext())!= null){
				// Insert into sounds table
				stmt4.bindNull(1); //pk
				stmt4.bindString(2, columns[0]); //fileName
				stmt4.bindString(3, columns[1]); //qString
				stmt4.bindString(4, columns[2]); //aString
				stmt4.bindLong(5, Integer.parseInt(columns[3])); //qStart
				stmt4.bindLong(6, Integer.parseInt(columns[4])); //qEnd
				stmt4.bindLong(7, Integer.parseInt(columns[5])); //aStart
				stmt4.bindLong(8, Integer.parseInt(columns[6])); //aEnd
				stmt4.bindLong(9, Integer.parseInt(columns[7])); //rating
				stmt4.executeInsert();				
			}
		
			db.setTransactionSuccessful();
		} catch(Exception e){
			throw e;
		} finally { // Anyway go back to the main window
			db.endTransaction();
		}
	}
}
