const pkg = require(`${__dirname}/../package.json`);
const protocolStr = 'flast';
const fileProtocolStr = `${protocolStr}-file`;

module.exports = {
    window: {
        titleBar: {
            tab: {
                close: 'このタブを閉じる',
                new: '新しいタブを開く'
            },
            buttons: {
                minimize: '最小化',
                maximize: {
                    maximize: '最大化',
                    restore: '元に戻す (縮小)'
                },
                close: '閉じる'
            }
        },
        toolBar: {
            back: 'Go back to the previous page (Alt+Left)',
            forward: 'Go forward to the next page (Alt+Right)',
            reload: {
                reload: 'Reload (Ctrl+R)',
                stop: 'Stop loading'
            },
            home: 'Go to the home page',
            addressBar: {
                info: {
                    info: 'Information on this page',
                    clicked: {
                        internal: `保護された ${pkg.name} ページを表示しています`,
                        secure: 'このサイトへの接続は保護されています',
                        insecure: 'このサイトへの接続は保護されていません'
                    }
                },
                bookmark: {
                    add: 'ブックマークに追加',
                    remove: 'ブックマークから削除',
                    clicked: {
                        add: 'ブックマークに追加しました',
                        remove: 'ブックマークから削除しました',
                        addPrivate: 'プライベート ブックマークに追加しました',
                        removePrivate: 'プライベート ブックマークから削除しました'
                    }
                },
            },
            extensions: {
                adBlock: '{replace}個の広告をブロックしました',
                feedback: 'Send Feedback'
            },
            menu: {
                menu: 'Menu',
                menus: {
                    newTab: 'New tab',
                    newWindow: 'New window',
                    openPrivateWindow: 'Open Private window',
                    history: 'History',
                    downloads: 'Downloads',
                    bookmarks: 'Bookmarks',
                    app: {
                        app: 'Application',
                        list: 'App list',
                        install: 'Install {title}',
                        uninstall: 'Uninstall {title}',
                        run: 'Launch {title}'
                    },
                    print: 'Print',
                    find: 'Find on page',
                    settings: 'Settings',
                    help: 'Help',
                    close: 'Close'
                }
            }
        },
        view: {
            contextMenu: {
                link: {
                    newTab: '新しいタブで開く',
                    newWindow: '新しいウィンドウで開く',
                    openPrivateWindow: 'プライベート ウィンドウで開く',
                    copy: 'リンクをコピー'
                },
                image: {
                    newTab: '新しいタブで画像を開く',
                    saveImage: '名前を付けて画像を保存',
                    copyImage: '画像をコピー',
                    copyLink: '画像アドレスをコピー'
                },
                editable: {
                    undo: 'Undo',
                    redo: 'Redo',
                    cut: 'Cut',
                    copy: 'Copy',
                    paste: 'Paste',
                    selectAll: 'Select all'
                },
                selection: {
                    copy: 'Copy',
                    textSearch: '{name}で「{text}」を検索'
                },
                back: 'Back',
                forward: 'Forward',
                reload: {
                    reload: 'Reload',
                    stop: 'Stop loading'
                },
                floatingWindow: 'Floating Window (Beta)',
                savePage: 'Save page',
                print: 'Print',
                viewSource: 'View source',
                devTool: 'Developer Tool'
            }
        }
    }
}