#include "StdAfx.h"
#include "IPv4ClientConnection.h"
#include "Context.h"
#include "ServerException.h"

#define	MAX_HEADER_SIZE	(16 * 1024)	//	16K
#define	END_HEADER		_U8("\r\n\r\n")


//////////////////////////////////////////////////////////////////////////////////////////////
//	RXgN^
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	RXgN^
*/
CIPv4ClientConnection::CIPv4ClientConnection(SOCKET sock, int timeout)
{
	m_socket.AttachSocket(sock);
	m_socket.SetTimeout(timeout);
}


/*!
	fXgN^
*/
CIPv4ClientConnection::~CIPv4ClientConnection(void)
{
	Close();
}


/////////////////////////////////////////////////////////////////////
//	IClientConnection
/////////////////////////////////////////////////////////////////////
/*!
	
*/
void CIPv4ClientConnection::AttacheToThread(IServerToolPtr serverTool, IConnectionThreadStatusPtr threadStatus)
{
	m_threadStatus = threadStatus;
	m_socket.SetExBreakEvent(m_threadStatus->GetBreakEvent());
}

/*!
	ؒf
*/
void CIPv4ClientConnection::Close()
{
	m_socket.Close();
}


/*!
	NCAg̎擾
*/
void CIPv4ClientConnection::GetClientInfo(IWorkspaceAccessPtr clientInfo)
{
	//	bp`
	CContextClientInfo info = CWorkspaceAccess(clientInfo);

	//	NCAg
	//	zXg͎ݒ肳Ȃ
	info.SetAcceptedPort(m_socket.GetPort());
	info.SetAcceptedAddress(m_socket.GetAddres());
	info.SetClientPort(m_socket.GetPeerPort());
	info.SetClientAddress(m_socket.GetPeerAddres());
}

/*!
	̐ڑ҂

	\return TRUE->oAFALSE->^CAEg
*/
int CIPv4ClientConnection::WaitNextRequest(int waitTime)
{
	return m_socket.WaitNextRequest(waitTime);
}

/*!
	ڑ擾
*/
int CIPv4ClientConnection::IsConnecting()
{
	return !m_socket.IsDisconnect();
}


/////////////////////////////////////////////////////////////////////
//	IClientConnection
/////////////////////////////////////////////////////////////////////
/*!
	wb_M(throw)
*/
void CIPv4ClientConnection::RecvRequestHeader(IStringPtr _requestHeader)
{
	CUTF8String	requestHeader;

	//	wb_M
	if(m_socket.RecvProtocolHeader(requestHeader, END_HEADER, MAX_HEADER_SIZE, FALSE))
		throw CConnectionErrorException(_U16("HTTPwb_̎MɎs܂: ") + m_socket.GetLastErrorString());

	//	ݒ
	_requestHeader->SetString(requestHeader);
}


/*!
	{fBM(throw)
*/
int CIPv4ClientConnection::RecvRequestBody(IBinaryDataPtr _body, int leftSize)
{
	//	bp`
	CBinaryData	body(_body);

	//	M
	int recved = m_socket.RecvBinary(body, leftSize);
	if(m_socket.GetLastError())
		throw CConnectionErrorException(_U16("f[^̎MɎs܂: ") + m_socket.GetLastErrorString());

	return(recved);
}


/*!
	wb_𑗐M(throw)
*/
void CIPv4ClientConnection::SendResponseHeader(IStringPtr _responseHeader)
{
	CUTF8String	responseHeader = _responseHeader->GetString();

	//	X|Xwb_M
	m_socket.SendString(responseHeader);
	if(m_socket.GetLastError())
		throw CConnectionErrorException(_U16("HTTPwb_̑MɎs܂: ") + m_socket.GetLastErrorString());
}

/*!
	{fB𑗐M(throw)
*/
void CIPv4ClientConnection::SendResponseBody(IBinaryDataPtr _body)
{
	//	bp`
	CBinaryData	body(_body);

	//	M
	m_socket.SendBinary(body);
	if(m_socket.GetLastError())
		throw CConnectionErrorException(_U16("f[^̑MɎs܂: ") + m_socket.GetLastErrorString());
}


