#include "StdAfx.h"
#include "IPv4Listener.h"
#include "ServerException.h"

#define	CLASS_NAME	_U8("NormalListener")


CIPv4Listener::CIPv4Listener(void)
{
	m_init = 0;
}

CIPv4Listener::~CIPv4Listener(void)
{
	Stop();
}



/*!
	Jn
*/
void CIPv4Listener::Start(IServerToolPtr serverTool, IClientConnectionQueuePtr queue)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	//	Rs[
	m_serverTool = serverTool;
	m_queue = queue;
	m_setting = m_serverTool.GetManagerSetting(m_setting.GetSettingName());

	//	ݒ擾
	m_timeoutTime = m_setting.GetConnectionTimeoutTime();

	//	Xi
	InitListenerBase(m_serverTool.GetIServerTool(), m_setting.GetListenErrorRetryTime());

	//	|[gǉ
	AddPortsFromSetting(m_setting.GetPort());

	//	|[gmF
	if(GetPortCount() == 0)
		throw CServerStartErrorException(CLASS_NAME, _U16("҂󂯃|[gЂƂw肳Ă܂"));

	//	XbhN
	StartListenerBase();
}

/*!
	~
*/
void CIPv4Listener::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	StopListenerBase();
}

/*!
	~
*/
void CIPv4Listener::ShutdownListen()
{
	Stop();	//	̃NXł͓
}

/////////////////////////////////////////////////////////////////////////////////////
//	I[o[[h
/////////////////////////////////////////////////////////////////////////////////////
/*!
	NX擾
*/
LPCU8STR CIPv4Listener::GetListenerClassName()
{
	return CLASS_NAME;
}

/*!
	ڑǉ
*/
void CIPv4Listener::OnNewConnection(SOCKET newSock)
{
	try
	{
		m_queue->AddNewConnection(new CIPv4ClientConnection(newSock, m_timeoutTime));
	}
	catch(CBadAllocException &e)
	{
		//	gȂ̂...
		UNREFERENCED_PARAMETER(e);

		//	O
		m_serverTool.WriteSystemLog(GetListenerClassName(), SYSTEM_LOG_ERROR, _U16("s܂AꎞIɐڑۂ܂"));

		//	ŝ߁AT[oꎞ~
		ForceDisableNewConnection(30 * 1000);
	}
}
