/*!
	CIPv4ListenerBase

	IPv4pnڑtNX̊{NX
*/

#pragma once
#include "ThreadSkeleton.h"
#include "ListenSocket.h"
#include "IListener.h"
#include "IServerToolWrap.h"
#include "Settings.h"

/*!
	IPv4pnڑtNX̊{NX
*/
class CIPv4ListenerBase :
	private CThreadSkeleton
{
public:
	CIPv4ListenerBase(void);
	virtual ~CIPv4ListenerBase(void);

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	I[o[[h
	/////////////////////////////////////////////////////////////////////////////////////
	//!	NX擾
	virtual LPCU8STR GetListenerClassName() = 0;

	//!	ڑǉ
	virtual void OnNewConnection(SOCKET newSock) = 0;

	/////////////////////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////////////////////
	//!	
	void InitListenerBase(CIServerToolWrap serverTool, int errorRetryTime);

	//!	Jn
	void StartListenerBase();

	//!	~
	void StopListenerBase();

	//!	ݒ肩|[gǉ
	void AddPortsFromSetting(CUTF8String strPorts);

	//!	|[g̒ǉ
	void AddPort(int port);

	//!	|[g擾
	int GetPortCount() { return m_listeners.GetCount(); };

	//!	ꎞIɎ󂯕t~
	void ForceDisableNewConnection(int time);

private:
	/////////////////////////////////////////////////////////////////////////////////////
	//	Xbh֐
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Xbh
	void ThreadMain();

	//!	N[Abv
	void CloseAllPorts();

	//!	t[v
	int AcceptLoop();

	//!	|[gJ
	int OpenPorts();

	//!	|[g
	void ClosePorts();

	//!	ڑ󂯕t
	int AcceptConnections();

	//!	ڑ̂҂
	void WaitNextRequest();

	//!	~H
	int InDisableMode();

	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	T[oc[
	CIServerToolWrap						m_serverTool;

	//!	Xiz
	CPtrArrayTemplate<CListenSocket*>		m_listeners;

	//!	G[gC
	int										m_errorRetryTime;

	//!	tI\
	DWORD									m_disableNewConnectionEndTime;
};
