#pragma once
#include "InterfaceWrapperMacro.h"
#include "IServerTool.h"

/*
#include "ILogManager.h"
#include "IServerTextManager.h"
#include "IMimeTypeManager.h"
#include "IPathManager.h"
#include "ICGIManager.h"
#include "IServerInfoManager.h"

#include "ServerStatus.h"
#include "ServerInfo.h"
*/
#include "ServerException.h"

/*!
	IServerTool̃bp
*/
class CIServerToolWrap
{
public:
	//!	FX錾
	DEFINE_MANAGER_WRAPPER_CONSTRUCTOR(CIServerToolWrap, IServerTool, 1);

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	ݒ
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	}l[W̌ʐݒ擾
	virtual CWorkspaceAccess GetManagerSetting(CUTF8String section)
	{
		CWorkspaceAccess	temp;
		m_ifPtr->GetServerWorkspaceAccess(temp.GetIWorkspaceAccessRef(), MANAGER_SETTING, section);
		return(temp);
	}

	//!	tB^̌ʐݒ擾
	virtual CWorkspaceAccess GetFilterSetting(CUTF8String section)
	{
		CWorkspaceAccess	temp;
		m_ifPtr->GetServerWorkspaceAccess(temp.GetIWorkspaceAccessRef(), FILTER_SETTING, section);
		return(temp);
	}

	//!	X|X̌ʐݒ擾
	virtual CWorkspaceAccess GetResponseSetting(CUTF8String section)
	{
		CWorkspaceAccess	temp;
		m_ifPtr->GetServerWorkspaceAccess(temp.GetIWorkspaceAccessRef(), RESPONSE_SETTING, section);
		return(temp);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	Xe[^XEO
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oȌ
	virtual void WriteSystemLog(CUTF8String callerName, int logType, CUTF8String logString)
	{
		m_ifPtr->WriteSystemLog(callerName, logType, logString);
	}

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusInt(CUTF8String statusName, int status, CUTF8String statusInfo = _U8(""), CUTF8String statusType = _U8("Interger"))
	{
		//	
		char	str[80] = "";
		_itoa_s(status, str, 80, 10);

		//	ݒ
		m_ifPtr->SetServerStatus(statusName, _U8(str), statusInfo, statusType);
	}

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusStr(CUTF8String statusName, CUTF8String status, CUTF8String statusInfo = _U8(""), CUTF8String statusType = _U8("String"))
	{
		m_ifPtr->SetServerStatus(statusName, status, statusInfo, statusType);
	}

	//!	T[obZ[Wʒm
	virtual void NotifyServerMessage(CUTF8String messageID, CUTF8String message, int messageType, int autoOffTimeSec = -1)
	{
		m_ifPtr->NotifyServerMessage(messageID, message, messageType, autoOffTimeSec);
	}

	//!	݂̃T[oXe[^X擾
/*	virtual CServerStatus GetServerStatus()
	{
		CWorkspaceAccess	temp;
		m_ifPtr->GetServerWorkspaceAccess(temp.GetIWorkspaceAccessRef(), SERVER_STATUS, NULL);
		return(temp);
	}
*/
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[XǗ
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[Xo^
	virtual int RegisterManagerInterface(CUTF8String interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface = NULL)
	{
		return m_ifPtr->RegisterManagerInterface(interfaceName, ifRegister, oldInterface);
	}

	//!	C^[tF[Xo^
	virtual int UnRegisterManagerInterface(CUTF8String interfaceName, IManagerInterfacePtr ifUnRegister, IManagerInterfacePtr oldInterface = NULL)
	{
		return m_ifPtr->UnRegisterManagerInterface(interfaceName, ifUnRegister, oldInterface);
	}

	//!	C^tF[X擾
	virtual void *GetManagerInterface(CUTF8String interfaceName, int ifVersion, int enableException = TRUE)
	{
		//	擾݂
		void *ifPtr = m_ifPtr->GetManagerInterface(interfaceName, ifVersion);

		//	G[`FbN
		if(ifPtr == NULL && enableException)
			throw CManagerInterfaceException(interfaceName, ifVersion);

		return(ifPtr);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*	//!	pX}l[W擾
	virtual CIPathManagerWrap GetIPathManager()
	{
		return (IPathManagerPtr)GetManagerInterface(CIPathManagerWrap::GetInterfaceName(), CIPathManagerWrap::GetInterfaceVersion());
	}

	//!	MimeType}l[W擾
	virtual CIMimeTypeManagerWrap GetIMimeTypeManager()
	{
		return (IMimeTypeManagerPtr)GetManagerInterface(CIMimeTypeManagerWrap::GetInterfaceName(), CIMimeTypeManagerWrap::GetInterfaceVersion());
	}

	//!	O}l[W擾
	virtual CILogManagerWrap GetILogManager()
	{
		return (ILogManagerPtr)GetManagerInterface(CILogManagerWrap::GetInterfaceName(), CILogManagerWrap::GetInterfaceVersion());
	}

	//!	T[oeLXg}l[W擾
	virtual CIServerTextManagerWrap GetIServerTextManager()
	{
		return (IServerTextManagerPtr)GetManagerInterface(CIServerTextManagerWrap::GetInterfaceName(), CIServerTextManagerWrap::GetInterfaceVersion());
	};

	//!	CGI}l[W擾
	virtual CICGIManagerWrap GetICGIManager()
	{
		return (ICGIManagerPtr)GetManagerInterface(CICGIManagerWrap::GetInterfaceName(), CICGIManagerWrap::GetInterfaceVersion());
	}

	//!	T[o}l[W擾
	virtual CIServerInfoManagerWrap GetIServerInfoManager()
	{
		return (IServerInfoManagerPtr)GetManagerInterface(CIServerInfoManagerWrap::GetInterfaceName(), CIServerInfoManagerWrap::GetInterfaceVersion());
	}
*/
};
