#pragma once
#include "workspaceaccess.h"
#include "WorkspaceListAccess.h"

/*!
	VXeO
*/
class CServerSystemLog :
	public CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerSystemLog);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Ăяo
	DEFINE_PROPERTY_METHOD_STR(Caller, _U8("Caller"), _U8(""));

	//!	Xe[^X
	DEFINE_PROPERTY_METHOD_STR(LogString, _U8("LogString"), _U8(""));

	//!	
	DEFINE_PROPERTY_METHOD_STR(Time, _U8("Time"), _U8(""));

	//!	R[h
	DEFINE_PROPERTY_METHOD_INT(LogType, _U8("LogType"), 0);
};
typedef CWorkspaceTypedListAccess<CServerSystemLog, CWTLAName<'L', 'o', 'g'>> CServerSystemLogList;


/*!
	Xe[^X
*/
class CServerStatusEntry :
	public CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerStatusEntry);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Xe[^X
	DEFINE_PROPERTY_METHOD_STR(StatusName, _U8("StatusName"), _U8(""));

	//!	
	DEFINE_PROPERTY_METHOD_STR(Status, _U8("Status"), _U8(""));

	//!	
	DEFINE_PROPERTY_METHOD_STR(StatusInfo, _U8("StatusInfo"), _U8(""));

	//!	`
	DEFINE_PROPERTY_METHOD_STR(StatusType, _U8("StatusType"), _U8("Integer"));

};


/*!
	ʒm
*/
class CServerNotifyEntry :
	public CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerNotifyEntry);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	vpeB
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ID
	DEFINE_PROPERTY_METHOD_STR(MessageID, _U8("MessageID"), _U8(""));

	//!	bZ[W
	DEFINE_PROPERTY_METHOD_STR(Message, _U8("Message"), _U8(""));

	//!	^Cv
	DEFINE_PROPERTY_METHOD_INT(MessageType, _U8("MessageType"), 0);

	//!	
	DEFINE_PROPERTY_METHOD_STR(Time, _U8("Time"), _U8(""));

	//!	
	DEFINE_PROPERTY_METHOD_INT(AutoOffTimeSec, _U8("AutoOffTimeSec"), -1);

};


class CServerStatus :
	public CWorkspaceAccess
{
public:
	//	RXgN^܂Ƃ߂Ē`
	DEFINE_COMMON_CONSTRUCTOR(CServerStatus);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	ʃANZX
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Xe[^XO擾
	CServerSystemLogList GetSystemLog() { return GetAccess(_U8("SystemLog")); };


	//!	T[oXe[^X擾
	CServerStatusEntry GetServerStatusEntry(CUTF8String statusName) { return GetAccess(_U8("Status::") + statusName); };

	//!	T[oXe[^X擾
	int GetServerStatusCount() { return GetAccess(_U8("Status")).GetSubNodeCount(); }


	//!	ʒm擾
	CServerNotifyEntry GetServerNotifyEntry(CUTF8String messageID) { return GetAccess(_U8("Notify::") + messageID); };

	//!	ʒm擾
	int GetServerNotifyCount() { return GetAccess(_U8("Notify")).GetSubNodeCount(); }
};
