#include "StdAfx.h"
#include "FilterManager.h"
#include "ServerInfoFilter.h"
#include "PathFilter.h"
#include "IndexFilter.h"
#include "AccessLogFilter.h"
#include "KeepAliveFilter.h"

/*!
	tB^x
*/
enum FILTER_LEVEL
{
	FILTER_LEVEL_SERVER_INFO		= 100000,

	FILTER_LEVEL_PATH				= 200000,

	FILTER_LEVEL_INDEX				= 300000,

	FILTER_LEVEL_KEEP_ALIVE			= 400000,

	FILTER_LEVEL_ACCESS_LOG			= 500000,
};


CFilterManager::CFilterManager(void)
{
}

CFilterManager::~CFilterManager(void)
{
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	EI
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CFilterManager::Start(CIServerToolWrap serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	//	ϐRs[
	m_serverTool = serverTool;

	//	ݒ擾
	m_setting = serverTool.GetManagerSetting(m_setting.GetSettingName());

	//	{tB^ǉ
	AddBasicFilters();

	//	tB^
	for(int i=0;i<m_filterFactorys.GetSize();i++)
		m_filterFactorys[i].Start(m_serverTool.GetIServerTool());

	//	C^tF[X
	m_managerInterface.Init((IFilterManagerPtr)this, FILTER_MANAGER_INTERFACE_VER);

	//	C^[tF[Xo^
	m_serverTool.RegisterManagerInterface(FILTER_MANAGER_INTERFACE_NAME, m_managerInterface.GetIManagerInterface());
}

/*!
	~
*/
void CFilterManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	~
	for(int i=0;i<m_filterFactorys.GetSize();i++)
		m_filterFactorys[i].Stop();
	m_filterFactorys.RemoveAll();

	//	C^[tF[Xo^
	m_serverTool.UnRegisterManagerInterface(FILTER_MANAGER_INTERFACE_NAME, m_managerInterface.GetIManagerInterface());
}


/*!
	tB^z擾
*/
void CFilterManager::GetFilterArray(CFilterArray &filters)
{
	SCOPE_LOCK();
	filters.RemoveAll();

	//	tB^z擾
	for(int i=0;i<m_filterFactorys.GetSize();i++)
		filters.Add(CIFilterWrapper::CreateWrapper(m_filterFactorys[i].GetFilter()));
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	⏕
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	{tB^ǉ
*/
void CFilterManager::AddBasicFilters()
{
	//	ׂĖH
	if(m_setting.GetDisableAllFilter())
		return;

	//	T[o
	if(!m_setting.GetDisableServerInfoFilter())
		AddFilterFactory((new CServerInfoFilterFactory())->GetIFilterFactory(), FILTER_LEVEL_SERVER_INFO);

	//	pX
	if(!m_setting.GetDisablePathFilter())
		AddFilterFactory((new CPathFilterFactory())->GetIFilterFactory(), FILTER_LEVEL_PATH);

	//	CfbNX
	if(!m_setting.GetDisableIndexFilter())
		AddFilterFactory((new CIndexFilterFactory())->GetIFilterFactory(), FILTER_LEVEL_INDEX);

	//	KeepAlive
	if(!m_setting.GetDisableKeepAliveFilter())
		AddFilterFactory((new CKeepAliveFilterFactory())->GetIFilterFactory(), FILTER_LEVEL_KEEP_ALIVE);

	//	ANZXO
	if(!m_setting.GetDisableAccessLogFilter())
		AddFilterFactory((new CAccessLogFilterFactory())->GetIFilterFactory(), FILTER_LEVEL_ACCESS_LOG);
}


/*!
	W[ǉ
*/
void CFilterManager::AddFilterFactory(IFilterFactoryPtr factory, int filterLevel)
{
	//	}ꏊ
	for(int i=0;i<m_filterFactorys.GetSize();i++)
	{
		if(m_filterFactorys[i].GetFilterLevel() > filterLevel)
		{
			//	}
			m_filterFactorys.InsertAt(i, CFilterFactoryArrayItem(CIFilterFactoryWrapper::CreateWrapper(factory), filterLevel));
			return;
		}
	}

	//	Ō
	m_filterFactorys.Add(CFilterFactoryArrayItem(CIFilterFactoryWrapper::CreateWrapper(factory), filterLevel));
}
