#pragma once
#include "filterbase.h"
#include "FilterBase.h"

#include "Settings.h"
#include "SyncObject.h"
#include "TextTools.h"

class CKeepAliveFilter :
	public CFilterBase
{
public:
	CKeepAliveFilter(void);
	virtual ~CKeepAliveFilter(void);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	eĂ΂
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void Init(CIServerToolWrap serverTool);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^擾
	virtual LPCTSTR GetFilterName();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	tB^O
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_
	virtual void FilterRequestHeader(CIConnectionToolWrap filterContext);

	//!	X|Xwb_
	virtual void FilterResponseHeader(CIConnectionToolWrap filterContext);

	//!	X|Xwb_(OցI)
	virtual void FilterServerResponse(CIConnectionToolWrap filterContext, CBinaryData &body)
	{
		//!	ʏƓs
		FilterResponseHeader(filterContext);
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection			m_scopeLock;

	//!	T[oc[
	CIServerToolWrap			m_serverTool;

	//!	ݒ
	CKeepAliveFilterSetting		m_setting;

	//!	KeepAliveL
	int							m_enableKeepAlive;

	//!	KeepAlive
	int							m_keepAliveTime;

	//!	KeepAlive
	int							m_keepAliveCount;
};



class CKeepAliveFilterFactory :
	public CFilterFactoryBase
{
public:
	CKeepAliveFilterFactory(void) {};
	virtual ~CKeepAliveFilterFactory(void) {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterFactory
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^擾
	IFilterPtr GetFilter()
	{
		return m_filter.GetIFilter();
	}

	//!	
	virtual void Start(CIServerToolWrap serverTool)
	{
		m_filter.Init(serverTool);
	}

	//!	폜
	virtual void Delete()
	{
		delete this;
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^
	CKeepAliveFilter			m_filter;
};
