#include "StdAfx.h"
#include "ListenerBase.h"
#include "ServerException.h"
#include "TextTools.h"


CListenerBase::CListenerBase(void)
{
}

CListenerBase::~CListenerBase(void)
{
	StopListenerBase();
}



/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
void CListenerBase::InitListenerBase(CIServerToolWrap serverTool, int errorRetryTime)
{
	m_serverTool = serverTool;
	m_errorRetryTime = errorRetryTime;
	m_disableNewConnectionEndTime = 0;
}

/*!
	Jn
*/
void CListenerBase::StartListenerBase()
{
	if(OpenPorts())
		throw CServerStartErrorException(GetListenerClassName(), "ڑ̑҂󂯊JnɎs܂");

	if(StartThread())
		throw CServerStartErrorException(GetListenerClassName(), "Xbh̋NɎs܂");
}

/*!
	~
*/
void CListenerBase::StopListenerBase()
{
	//	Xbh~
	EndThread();

	//	|
	CloseAllPorts();
}

/*!
	N[Abv
*/
void CListenerBase::CloseAllPorts()
{
	//	|
	for(int i=0;i<m_listeners.GetSize();i++)
		delete m_listeners[i];
	m_listeners.RemoveAll();
}

/*!
	ݒ肩|[gǉ
*/
void CListenerBase::AddPortsFromSetting(CString strPorts)
{
	//	|[g擾
	CStringArray	ports;
	CTextTools::GetAllToken(strPorts, ports, ",", TRUE);

	//	o^
	for(int i=0;i<ports.GetSize();i++)
	{
		int port = atoi(ports[i]);

		if(port > 0 && port < 65536)
			AddPort(port);
	}
}

/*!
	|[g̒ǉ
*/
void CListenerBase::AddPort(int port)
{
	//	֎~
	if(IsRunning())
		return;

	//	ǉ
	m_listeners.Add(new CListenSocket(port));

	//	O
	m_serverTool.WriteSystemLog(GetListenerClassName(), SYSTEM_LOG_INFO, CTextTools::GetFormat("|[g %d ǉ܂", port));

}


/*!
	ꎞIɎ󂯕t~
*/
void CListenerBase::ForceDisableNewConnection(int time)
{
	m_disableNewConnectionEndTime = GetTickCount() + time;
}

/////////////////////////////////////////////////////////////////////////////////////
//	Xbh֐
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Xbh
*/
void CListenerBase::ThreadMain()
{
	//	G[[v
	while(!GetBreak())
	{
		//	[v
		AcceptLoop();

		//	|[g̑҂󂯂蒼
		while(!GetBreak() && OpenPorts())
			WaitForSomeObjects(m_errorRetryTime, GetBreakEvent());	//	G[Ȃ̂ŁA΂炭ҋ@
	}

	//	
	ClosePorts();

	//	ŏIXe[^X
	m_serverTool.WriteSystemLog(GetListenerClassName(), SYSTEM_LOG_INFO, "|[g҂󂯂~܂");
}

/*!
	t[v
*/
int CListenerBase::AcceptLoop()
{
	//	҂󂯃[v
	while(!GetBreak())
	{
		//	݂
		if(AcceptConnections())
			return(-1);		//	G[

		//	Cxg҂
		WaitNextRequest();
	}

	return(0);
}


/*!
	|[gJ
*/
int CListenerBase::OpenPorts()
{
	//	܂́Aׂĕ
	ClosePorts();

	//	SẴ|[gJ
	for(int i=0;i<m_listeners.GetSize();i++)
	{
		//	҂󂯊Jn
		if(m_listeners[i]->StartListen())
		{
			//	G[
			m_serverTool.WriteSystemLog(GetListenerClassName(), SYSTEM_LOG_ERROR,
				CTextTools::GetFormat("|[g %d ̑҂󂯊JnɎs܂", m_listeners[i]->GetPort()));
			return(-1);
		}
	}

	//	
	m_serverTool.WriteSystemLog(GetListenerClassName(), SYSTEM_LOG_INFO, "S|[g̑҂󂯂Jn܂");
	return(0);
}

/*!
	|[g
*/
void CListenerBase::ClosePorts()
{
	//	SẴ|[g
	for(int i=0;i<m_listeners.GetSize();i++)
	{
		//	҂󂯒~
		m_listeners[i]->EndListen();
	}
}


/*!
	ڑ󂯕t
*/
int CListenerBase::AcceptConnections()
{
	//	e|
	SOCKET		newSock;
	CIPAddress	ip;

	while(1)
	{
		//	SẴ|[g`FbN
		int	acceptedCount = 0;
		for(int i=0;i<m_listeners.GetSize();i++)
		{
			//	t݂
			switch(m_listeners[i]->TryAccept(newSock, ip))
			{
			//	\PbgȂ
			case LISTEN_SOCKET_NOCLIENT:
				break;

			//	G[
			case LISTEN_SOCKET_ERROR:
				m_serverTool.WriteSystemLog(GetListenerClassName(), SYSTEM_LOG_ERROR,
					CTextTools::GetFormat("|[g %s ̐ڑtŃG[܂", m_listeners[i]->GetPort()));
				return(-1);

			//	VKڑ
			case LISTEN_SOCKET_ACCEPTED:
				acceptedCount++;

				//	H
				if(InDisableMode())
					closesocket(newSock);		//	폜
				else
					OnNewConnection(newSock);

				TRACE("New connection\n");
				break;
			}
		}

		//	ʖ
		if(acceptedCount == 0)
			return(0);
	}
}



/*!
	ڑ̂҂
*/
void CListenerBase::WaitNextRequest()
{
	//	Cxg
	int	eventCount = m_listeners.GetSize();
	if(eventCount > MAXIMUM_WAIT_OBJECTS - 1)
		eventCount = MAXIMUM_WAIT_OBJECTS - 1;

	//	ׂẴCxg擾
	HANDLE	waits[MAXIMUM_WAIT_OBJECTS];
	for(int i=0;i<eventCount;i++)
		waits[i+1] = m_listeners[i]->GetEventHandle();

	//	҂
	waits[0] = GetBreakEvent();
	::WaitForMultipleObjects(eventCount + 1, waits, FALSE, INFINITE);
}


/*!
	~H
*/
int CListenerBase::InDisableMode()
{
	if(m_disableNewConnectionEndTime != 0)
	{
		DWORD	tick = GetTickCount();
		if(m_disableNewConnectionEndTime < tick || m_disableNewConnectionEndTime >= tick)
		{
			m_disableNewConnectionEndTime = 0;
			return(0);
		}
		return(1);
	}
	return(0);
}
