#pragma once

#include "ServerToolWrap.h"
#include "Settings.h"
#include "SyncObject.h"
#include "IPathManager.h"
#include "SimpleManagerInterfaceImplement.h"

/*!
	pX}l[W
*/
class CPathManager : public IPathManager
{
public:
	CPathManager(void);
	virtual ~CPathManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

protected:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	IPathManager
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	pX
	virtual int FindPath(LPCSTR path, LPCSTR host, IWorkspaceAccessPtr pathInfo)
	{
		return _FindPath(path, host, CWorkspaceAccess(pathInfo));
	}

	//!	pX擾
	virtual int GetPathCount();

	//!	CfbNXpX擾
	virtual int GetPathByIndex(int index, IWorkspaceAccessPtr pathInfo)
	{
		return _GetPathByIndex(index, CWorkspaceAccess(pathInfo));
	}

	///////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	pX
	virtual int _FindPath(CString path, CString host, CPathInfo pathInfo);

	//!	CfbNXpX擾
	virtual int _GetPathByIndex(int index, CPathInfo pathInfo);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection					m_scopeLock;

	//!	tO
	CInterlockCounter					m_init;

	//!	IServerTool
	CIServerToolWrap					m_serverTool;

	//!	C^tF[X
	CSimpleManagerInterfaceImplement	m_managerInterface;

	//!	pXݒ
	CPathManagerSetting					m_pathSetting;

	//!	pXXg
	CPathInfoList						m_pathList;

	//!	pXCfbNX
	CStringArray						m_pathIndex;

	//!	pXCfbNX()
	CArray<int>							m_pathIndexLen;

	//!	o[`zXgCfbNX
	CStringArray						m_hostIndex;

	//!	o[`zXg
	int									m_enableVirtualHost;
};
