#include "StdAfx.h"
#include "WorkspaceXMLWriter.h"
#include "TypedBuffer.h"

CWorkspaceXMLWriter::CWorkspaceXMLWriter(void)
{
}

CWorkspaceXMLWriter::~CWorkspaceXMLWriter(void)
{
}

/*!
	XMLo(throw CWorkspaceXMLWriterException)
*/
CString CWorkspaceXMLWriter::ToString(CWorkspaceNode *root, CString workspaceClassType)
{
	m_xml.Empty();
	m_xml.SetGrowSize(65536);
	m_workspaceClassType = workspaceClassType;

	//	wb_o
	WriteHeader();

	//	f[^o
	CTextEscape	escape;
	escape.AddEscape(_T("<"), _T("&lt;"));
	escape.AddEscape(_T(">"), _T("&gt;"));
	escape.AddEscape(_T("&"), _T("&amp;"));
	WriteSubNode(root, escape, _T("\t"));

	//	tb^o
	WriteFooter();

	//	UTF16֕ϊ
	CStringW			utf16(m_xml.GetCString());

	//	UTF8֕ϊ
	int mbLen = WideCharToMultiByte(CP_UTF8, 0, utf16.GetBuffer(0), utf16.GetLength(), NULL, 0, NULL, NULL);
	CString	utf8;
	WideCharToMultiByte(CP_UTF8, 0, utf16.GetBuffer(0), utf16.GetLength(), utf8.GetBuffer(mbLen + 1), mbLen, NULL, NULL);
	utf8.ReleaseBufferSetLength(mbLen);

	return utf8;
}

/*!
	t@C֏o
*/
void CWorkspaceXMLWriter::SaveToFile(CWorkspaceNode *root, CString path, CString workspaceClassType)
{
	CString utf8 = ToString(root, workspaceClassType);

	//	J
	FILE	*out;
	if(_tfopen_s(&out, path, _T("wb")) != 0)
		throw CWorkspaceXMLWriterException(_T("t@C̃I[vɎs܂"));

	fwrite((LPCSTR)utf8, utf8.GetLength(), 1, out);
	fclose(out);
}


/////////////////////////////////////////////////////////////////////////////
//	o͊֐
/////////////////////////////////////////////////////////////////////////////
/*!
	wb_[o
*/
void CWorkspaceXMLWriter::WriteHeader()
{
	m_xml.AppendLPCSTR("<?xml version=\"1.0\"?>\r\n<!--Soft3304 CWorkspace class.-->\r\n<CWorkspaceClass type=\"");
	m_xml.AppendString(m_workspaceClassType);
	m_xml.AppendLPCSTR("\">\r\n");
}

/*!
	tb^[o
*/
void CWorkspaceXMLWriter::WriteFooter()
{
	m_xml.AppendLPCSTR("</CWorkspaceClass>\r\n");
}


/*!
	Pm[ho
*/
void CWorkspaceXMLWriter::WriteSubNode(CWorkspaceNode *node, CTextEscape &escape, CString tab)
{
	//	o
	m_xml.AppendString(tab);
	m_xml.AppendLPCSTR("<Subnode name=\"");
	m_xml.AppendLPCSTR(node->GetNodeName());
	m_xml.AppendLPCSTR("\">\r\n");

	//	L[o
	for(int i=0;;i++)
	{
		CWorkspaceKeyPair *key = node->GetKeyByIndex(i);
		if(key == NULL)
			break;

		//	ϊ
		CString data = escape.Escape(key->GetData());

		//	o
		m_xml.AppendString(tab);
		m_xml.AppendLPCSTR("\t<Key name=\"");
		m_xml.AppendLPCSTR(key->GetKey());
		m_xml.AppendLPCSTR("\">");
		m_xml.AppendString(data);
		m_xml.AppendLPCSTR("</Key>\r\n");
	}

	//	Tum[ho
	for(int i=0;;i++)
	{
		CWorkspaceNode *subnode = node->GetSubNodeByIndex(i);
		if(subnode == NULL)
			break;

		//	o
		WriteSubNode(subnode, escape, tab + _T("\t"));
	}

	//	
	m_xml.AppendString(tab);
	m_xml.AppendLPCSTR("</Subnode>\r\n");
}
