#include "StdAfx.h"
#include "ServerStatusManager.h"
#include "DirTools.h"
#include "DateTools.h"

#define	MAX_SYSTEM_LOG		200
#define	MAX_NOTIFY			200
#define	MAX_STATUS			200
#define	CLASS_NAME			_U8("StatusManager")


CServerStatusManager::CServerStatusManager(void)
{
	m_serverStatus = m_statusRoot.GetAccess(_U8("ServerStatus"));
}

CServerStatusManager::~CServerStatusManager(void)
{
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CServerStatusManager::Start(CIServerToolWrap serverTool)
{
	ASSERT(!m_init);
	m_init = TRUE;

	//	VXeO
	m_systemLog.Start(serverTool.GetIServerTool());
}

/*!
	~
*/
void CServerStatusManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;

	//	~
	m_systemLog.Stop();

	m_init = FALSE;
}

/*!
	Oo
*/
void CServerStatusManager::WriteSystemLog(CUTF8String callerName, int logType, CUTF8String logString)
{
	//	[NXy[XbN
	WORKSPACE_LOCK(m_serverStatus);

	//	Ŝ
	logString.Replace(_U8("\r"), _U8("_"));
	logString.Replace(_U8("\n"), _U8("_"));

	//	ŐVACe擾
	CServerSystemLog systemLog = m_serverStatus.GetSystemLog().GetNewItem();
	systemLog.SetCaller(callerName);
	systemLog.SetLogType(logType);
	systemLog.SetLogString(logString);
	systemLog.SetTime(CDateTools::GetTimeString(CTime_t::GetCurrentTime()));

	//	ACemF
	if(m_serverStatus.GetSystemLog().GetItemCount() > MAX_SYSTEM_LOG)
		m_serverStatus.GetSystemLog().DeleteItem(0);

	TRACE_U8(_U16("<%s> %s\n"), callerName, logString);

	//	KvȂ烍Ot@C
	if(logType <= SYSTEM_LOG_INFO_LOG)
		m_systemLog.WriteSystemLog(callerName, logString);

	//	KvȂʒm
	if(logType <= SYSTEM_LOG_WARNING)
	{
		if(logType <= SYSTEM_LOG_ERROR)
			NotifyServerMessage(_U8("SystemLogErrorNotify"), _U16("G[܂: ") + logString, SYSTEM_MESSAGE_ERROR);
		else
			NotifyServerMessage(_U8("SystemLogWarningNotify"), _U16("x܂: ") + logString, SYSTEM_MESSAGE_WARNING, 60 * 60);	//	1ԂŎ
	}
};


/*!
	T[oXe[^X̕ύX
*/
void CServerStatusManager::SetServerStatus(CUTF8String statusName, CUTF8String status, CUTF8String statusInfo, CUTF8String statusType)
{
	//	[NXy[XbN
	WORKSPACE_LOCK(m_serverStatus);

	//	Xe[^XmF
	if(m_serverStatus.GetServerStatusCount() >= MAX_STATUS)
		return;	//	ȏǉs\

	//	Gg擾
	CServerStatusEntry entry = m_serverStatus.GetServerStatusEntry(statusName);

	//	Ggݒ
	entry.SetStatus(status);
	if(!statusInfo.IsEmpty())
		entry.SetStatusInfo(statusInfo);
	if(!statusType.IsEmpty())
		entry.SetStatusType(statusType);
}

/*!
	T[obZ[Wʒm
*/
void CServerStatusManager::NotifyServerMessage(CUTF8String messageID, CUTF8String message, int messageType, int autoOffTimeSec)
{
	//	[NXy[XbN
	WORKSPACE_LOCK(m_serverStatus);

	//	Xe[^XmF
	if(m_serverStatus.GetServerNotifyCount() >= MAX_NOTIFY)
		return;	//	ȏǉs\

	//	Gg擾
	CServerNotifyEntry entry = m_serverStatus.GetServerNotifyEntry(messageID);

	//	Ggݒ
	entry.SetMessageID(messageID);
	entry.SetMessage(message);
	entry.SetMessageType(messageType);
	entry.SetAutoOffTimeSec(autoOffTimeSec);
	entry.SetTime(CDateTools::GetTimeString(CTime_t::GetCurrentTime()));
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	擾
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Xe[^X擾
*/
void CServerStatusManager::DuplicateStatus(CWorkspace &status)
{
	status.Duplicate(m_statusRoot);
}
