/*!
	[NXy[Xւ̃Xg^ANZX񋟂NX
*/
#pragma once
#include "WorkspaceAccess.h"

/*****************************************************************************************************/
//	񃊃XgNX
/*****************************************************************************************************/
/*!
	񃊃XgƂẴANZX
*/
class CWorkspaceStringListAccess :
	public CWorkspaceAccess
{
public:
	CWorkspaceStringListAccess(CUTF8String listName);
	CWorkspaceStringListAccess(CWorkspaceAccess &other, CUTF8String listName);
	virtual ~CWorkspaceStringListAccess(void);

	//!	CWorkspaceAccess ݒ
	void operator = (CWorkspaceAccess &other) {	CWorkspaceAccess::operator=(other); }

	//////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////
	//!	̎擾
	int GetItemCount();

	//!	ACe̎擾
	CUTF8String GetItem(int index);

	//!	ACe̐ݒ
	void SetItem(int index, CUTF8String str);

	//!	ACeǉ
	void AddNewItem(CUTF8String str, int checkExist = FALSE, int noCase = FALSE);

	//!	ACe̍폜
	void DeleteItem(int index);

	//!	܂Ƃ߂Ēǉ
	void AddList(CUTF8StringArray &list, int checkExist = FALSE, int noCase = FALSE);

	//!	܂Ƃ߂Ď擾
	void GetList(CUTF8StringArray &list);

	//////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////
	//!	
	int FindIndex(CUTF8String str, int noCase = FALSE);

protected:
	/////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////
	//!	O
	CUTF8String			m_listName;
};


/*****************************************************************************************************/
//	XgNX
/*****************************************************************************************************/
/*!
	Workspace List ̃\[gsC^tF[X
*/
class IWorkspaceListAccessSortBase
{
public:
	//////////////////////////////////////////////////////////////////////////////
	//	r
	//////////////////////////////////////////////////////////////////////////////
	//!	Oǂ擾
	virtual int IsBefore(CWorkspaceAccess from, CWorkspaceAccess to) = 0;
};


/*!
	Workspace List
*/
class CWorkspaceListAccess : public CWorkspaceAccess
{
public:
	CWorkspaceListAccess(CUTF8String listName);
	CWorkspaceListAccess(CWorkspaceAccess &other, CUTF8String listName);
	virtual ~CWorkspaceListAccess(void);

	//!	CWorkspaceAccess ݒ
	void operator = (CWorkspaceAccess &other) {	CWorkspaceAccess::operator=(other); }

	//////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////
	//!	̎擾
	int GetItemCount();

	//!	ACe̎擾
	CWorkspaceAccess GetItem(int index);

	//!	ACeǉ
	CWorkspaceAccess GetNewItem();

	//!	ACe̍폜
	void DeleteItem(CWorkspaceAccess item);

	//!	ACe̍폜
	void DeleteItem(int index);

	//////////////////////////////////////////////////////////////////////////////
	//	\[g
	//////////////////////////////////////////////////////////////////////////////
	//!	\[g
	void Sort(IWorkspaceListAccessSortBase &sortBase, int reverse = FALSE);

	//!	\[g(L[e)
	void Sort(CUTF8String key1, CUTF8String key2 = _U8(""), CUTF8String key3 = _U8(""));

protected:
	/////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////
	//!	O
	CUTF8String			m_listName;
};


/*****************************************************************************************************/
//	\[gpNX
/*****************************************************************************************************/
/*!
	Workspace List ̃\[gsNX

	ASCIIR[hɐ񂷂B
	rL[炩ߎw肷
*/
class CWorkspaceListAccessSimpleSort : public IWorkspaceListAccessSortBase
{
public:
	//////////////////////////////////////////////////////////////////////////////
	//	r
	//////////////////////////////////////////////////////////////////////////////
	//!	Oǂ擾
	virtual int IsBefore(CWorkspaceAccess from, CWorkspaceAccess to);

	//////////////////////////////////////////////////////////////////////////////
	//	L[̒ǉ
	//////////////////////////////////////////////////////////////////////////////
	/*!
		AC擾
	*/
	CUTF8StringArray &GetKeyArray()
	{
		return m_keyNameArray;
	}

	/*!
		ǉ
	*/
	void AddKeyName(CUTF8String keyName)
	{
		m_keyNameArray.Add(keyName);
	}

	/*!
		NA
	*/
	void ClearKeyName()
	{
		m_keyNameArray.RemoveAll();
	}


protected:
	//////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////
	//!	rL[
	CUTF8StringArray	m_keyNameArray;
};


/*****************************************************************************************************/
//	XgNX ^wev[g
/*****************************************************************************************************/
/*!
	Workspace List

	Xgev[gƂėpł郊XgNX
*/
template<class TYPE, class STATIC_NAME>
class CWorkspaceTypedListAccess : public CWorkspaceListAccess
{
public:
	CWorkspaceTypedListAccess()
		: CWorkspaceListAccess(STATIC_NAME().GetName()) {};
	CWorkspaceTypedListAccess(CWorkspaceAccess &other)
		 : CWorkspaceListAccess(other, STATIC_NAME().GetName()) {};

	//!	CWorkspaceAccess ݒ
	void operator = (CWorkspaceAccess &other) {	CWorkspaceListAccess::operator=(other); }

	//////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////
	//!	ACe̎擾
	TYPE GetItem(int index) { return CWorkspaceListAccess::GetItem(index); };

	//!	ACeǉ
	TYPE GetNewItem() { return CWorkspaceListAccess::GetNewItem(); };
};


/*!
	X^eBbNev[g

	ev[g̕׍Hp
*/
template<	char s0  = 0, char s1  = 0, char s2  = 0, char s3  = 0, 
			char s4  = 0, char s5  = 0, char s6  = 0, char s7  = 0, 
			char s8  = 0, char s9  = 0, char s10 = 0, char s11 = 0, 
			char s12 = 0, char s13 = 0, char s14 = 0, char s15 = 0 >
class CWTLAName
{
public:
	/*!
		RXgN^
	*/
	CWTLAName()
	{
		char name[17] = {	 s0,  s1,  s2,  s3,
							 s4,  s5,  s6,  s7,
							 s8,  s9, s10, s11,
							s12, s13, s14, s15, 0};

		//	
		m_name = _cnvU8((LPCSTR)name);
	};


	/*!
		擾
	*/
	CUTF8String GetName()
	{
		return m_name;
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////
	//	擾ꂽ
	CUTF8String	m_name;
};
