#pragma once
#include <new>
#include "types/UTF8Types.h"
#include "UTF8StringMemoryPool.h"

//!	ŒmۃTCY
#define	MIN_ALLOC_LENGTH	1024



/*!
	UTF8ێNX

	̃NX̃CX^X́ACUTF8StringŋL
	obt@̐擪Ɋ蓖Ă
*/
class CUTF8StringData
{
public:
	////////////////////////////////////////////////////////////////////////////////
	//	p
	////////////////////////////////////////////////////////////////////////////////
	/*!
		
	*/
	static CUTF8StringData *GetNewString(int length, CUTF8StringData *duplicate = NULL, int isGrow = FALSE)
	{
		//	TCYvZ
		int	allocLen = length + 1;
		if(isGrow)
			allocLen *= 2;
		if(allocLen < MIN_ALLOC_LENGTH)
			allocLen = MIN_ALLOC_LENGTH;

		//	obt@m
		unsigned char *data = g_utf8StringMemoryPool.Alloc(sizeof(CUTF8StringData) + sizeof(utf8_char) * allocLen);

		//	}N`Azunew
		#pragma push_macro("new")
		#undef new
		CUTF8StringData *ret = new(data) CUTF8StringData(length, allocLen);
		#pragma pop_macro("new")

		//	KvȂRs[
		if(duplicate != NULL)
		{
			int	copyLen = length;
			if(copyLen > duplicate->GetLength())
				copyLen = duplicate->GetLength();
			memmove(ret->GetWritableString(), duplicate->GetString(), copyLen + 1);
		}

		return(ret);
	}


public:
	////////////////////////////////////////////////////////////////////////////////
	//	t@XJE^
	////////////////////////////////////////////////////////////////////////////////
	/*!
		t@XJE^
	*/
	void IncementRef()
	{
		//	CNg
		::InterlockedIncrement(&m_refCount);
	}

	/*!
		t@XJE^
	*/
	void DecrementRef()
	{
		//	fNg
		if(::InterlockedDecrement(&m_refCount) == 0)
			DeleteString(this);	//	폜
	}

	////////////////////////////////////////////////////////////////////////////////
	//	
	////////////////////////////////////////////////////////////////////////////////
	/*!
		񏑂|C^擾
	*/
	LPCU8STR GetString() const
	{
		//	ʒu擾
		return((LPCU8STR)(((char*)this) + sizeof(CUTF8StringData)));
	}

	/*!
		|C^擾
	*/
	LPU8STR GetWritableString()
	{
		//	t@XJEg`FbN
		ASSERT(CanWrite());

		//	ʒu擾
		return((LPU8STR)(((char*)this) + sizeof(CUTF8StringData)));
	}

	////////////////////////////////////////////////////////////////////////////////
	//	擾
	////////////////////////////////////////////////////////////////////////////////
	/*!
		݉\mF
	*/
	int CanWrite()
	{
		return(::InterlockedExchangeAdd(&m_refCount, 0) == 1);
	}


	/*!
		擾
	*/
	int GetLength()
	{
		return m_strLength;
	}

	/*!
		\Ȃ璷ύX
	*/
	int SetLength(int length)
	{
		//	t@XJEg`FbN
		ASSERT(CanWrite());

		//	obt@mF
		if(length + 1 > m_bufLength)
			return(-1);

		m_strLength = length;
		return(0);
	}


protected:
	////////////////////////////////////////////////////////////////////////////////
	//	RXgN^
	////////////////////////////////////////////////////////////////////////////////
	/*!
		RXgN^
	*/
	CUTF8StringData(int length, int bufLength)
	{
		m_strLength = length;
		m_bufLength = bufLength;
		m_refCount = 1;
	}

	/*!
		j
	*/
	static void DeleteString(CUTF8StringData *toDelete)
	{
		//	t@XJEgmF
		ASSERT(toDelete->m_refCount == 0);

		//	fXgN^R[
		toDelete->~CUTF8StringData();

		//	폜
		g_utf8StringMemoryPool.Free((unsigned char *)toDelete);
	}

	////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	////////////////////////////////////////////////////////////////////////////////
	//!	TCY
	int		m_strLength;

	//!	obt@TCY
	int		m_bufLength;

	//!	t@XJE^
	LONG	m_refCount;
};
