#include "StdAfx.h"
#include "WorkspaceAccess.h"


/////////////////////////////////////////////////////////////////////////////
//	RXgN^
/////////////////////////////////////////////////////////////////////////////
/*!
	RXgN^
*/
CWorkspaceAccess::CWorkspaceAccess(void)
{
	m_path = _U8("");
	m_root = NULL;
}

/*!
	RXgN^(IWorkspaceAccessPtr)
*/
CWorkspaceAccess::CWorkspaceAccess(IWorkspaceAccessPtr access)
{
	CIStringWrap	path;
	access->GetAccessPath(&path);
	
	Init(access->GetIWorkspacePtr(), path);
}

/*!
	RXgN^(IWorkspacePtr)
*/
CWorkspaceAccess::CWorkspaceAccess(IWorkspacePtr root, CUTF8String path)
{
	Init(root, path);
}


/////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////
/*!
	
*/
void CWorkspaceAccess::Init(IWorkspacePtr root, CUTF8String path)
{
	//	m[hpX֕ϊ
	if(path.GetLength() >= 2)
	{
		if(path.Right(2) != _U8("::"))
			path += _U8("::");
	}
	else
		path += _U8("::");

	m_path = path;
	m_root = root;
}


/////////////////////////////////////////////////////////////////////////////
//	Ȃ
/////////////////////////////////////////////////////////////////////////////
/*!
	Sf[^NA
*/
void CWorkspaceAccess::Clear(void)
{
	ASSERT(m_root != NULL);

	m_root->Clear(m_path);
}


/*!
	
*/
void CWorkspaceAccess::Copy(CWorkspaceAccess &src)
{
	ASSERT(m_root != NULL);

	m_root->Copy(m_path, src.m_path, src.m_root);
}


/*!
	ANZXNX擾
*/
CWorkspaceAccess CWorkspaceAccess::GetAccess(CUTF8String subPath)
{
	ASSERT(m_root != NULL);

	return CWorkspaceAccess(m_root,m_path + subPath);
}


/*!
	[g擾
*/
IWorkspacePtr CWorkspaceAccess::GetRoot()
{
	return(m_root);
}

/*!
	O擾
*/
CUTF8String CWorkspaceAccess::GetNodeName()
{
	//	̂Q
	CUTF8String	path = m_path;
	if(path.Right(2) == _U8("::"))
		path = path.Left(path.GetLength() - 2);

	int index = path.ReverseFind(':');
	if(index == -1)
		return(path);
	return(path.Mid(index + 1));
}

/*!
	pX擾
*/
CUTF8String CWorkspaceAccess::GetPath()
{
	return(m_path);
}



/////////////////////////////////////////////////////////////////////////////
//	f[^擾ݒ菈
/////////////////////////////////////////////////////////////////////////////
/*!
	f[^̐ݒ()
*/
void CWorkspaceAccess::SetKeyStr(CUTF8String key, CUTF8String data ,int noCase)
{
	ASSERT(m_root != NULL);

	m_root->SetKeyData(m_path + key,data);
}


/*!
	f[^̐ݒ(int)
*/
void CWorkspaceAccess::SetKeyInt(CUTF8String key, int data ,int noCase)
{
	ASSERT(m_root != NULL);

	TCHAR	buf[80] = _U16("");
	_itot_s(data, buf, 80, 10);
	m_root->SetKeyData(m_path + key, (LPCU8STR)buf);
}


/*!
	f[^̐ݒ(int64)
*/
void CWorkspaceAccess::SetKeyInt64(CUTF8String key, __int64 data ,int noCase)
{
	ASSERT(m_root != NULL);

	TCHAR	buf[80] = _U16("");
	_i64tot_s(data, buf, 80, 10);
	m_root->SetKeyData(m_path + key, (LPCU8STR)buf);
}


/*!
	f[^̐ݒ(DWORD)
*/
void CWorkspaceAccess::SetKeyDWORD(CUTF8String key, DWORD data ,int noCase)
{
	ASSERT(m_root != NULL);

	TCHAR	buf[80] = _U16("");
	_ui64tot_s(data, buf, 80, 10);
	m_root->SetKeyData(m_path + key, (LPCU8STR)buf);
}



/*!
	f[^̎擾()
*/
CUTF8String CWorkspaceAccess::GetKeyStr(CUTF8String key, CUTF8String defaultData ,int noCase)
{
	ASSERT(m_root != NULL);

	CIStringWrap	ret;
	m_root->GetKeyData(&ret, m_path + key, defaultData, noCase);

	return(ret.GetString());
}


/*!
	f[^̎擾(int)
*/
int CWorkspaceAccess::GetKeyInt(CUTF8String key, int defaultData ,int noCase)
{
	ASSERT(m_root != NULL);

	CIStringWrap	ret;
	m_root->GetKeyData(&ret, m_path + key, _U8(""), noCase);

	if(ret.IsEmpty())
		return(defaultData);
	else
		return(atoi((LPCSTR)ret.GetString()));	//	MBCS֕ῗȂ
}


/*!
	f[^̎擾(int64)
*/
__int64 CWorkspaceAccess::GetKeyInt64(CUTF8String key, __int64 defaultData ,int noCase)
{
	ASSERT(m_root != NULL);

	CIStringWrap	ret;
	m_root->GetKeyData(&ret, m_path + key, _U8(""), noCase);

	if(ret.IsEmpty())
		return(defaultData);
	else
		return(_atoi64((LPCSTR)ret.GetString()));	//	MBCS֕ῗȂ
}


/*!
	f[^̎擾(DWORD)
*/
DWORD CWorkspaceAccess::GetKeyDWORD(CUTF8String key, DWORD defaultData ,int noCase)
{
	ASSERT(m_root != NULL);

	CIStringWrap	ret;
	m_root->GetKeyData(&ret, m_path + key, _U8(""), noCase);

	if(ret.IsEmpty())
		return(defaultData);
	else
		return((DWORD)_atoi64((LPCSTR)ret.GetString()));	//	MBCS֕ῗȂ
}


/////////////////////////////////////////////////////////////////////////////
//	KeyɊւ鏈
/////////////////////////////////////////////////////////////////////////////
/*!
	L[擾
*/
int CWorkspaceAccess::GetKeyCount()
{
	ASSERT(m_root != NULL);

	return(m_root->GetKeyCount(m_path));
}


/*!
	SẴL[𕶎ƂĎ擾
*/
int CWorkspaceAccess::GetAllKey(CUTF8StringArray &list)
{
	ASSERT(m_root != NULL);

	CIStringArrayWrap	iList(list);
	return(m_root->GetAllKeyPair(m_path, &iList, NULL));
}

/*!
	SẴf[^𕶎ƂĎ擾
*/
int CWorkspaceAccess::GetAllData(CUTF8StringArray &list)
{
	ASSERT(m_root != NULL);

	CIStringArrayWrap	iList(list);
	return(m_root->GetAllKeyPair(m_path, NULL, &iList));
}



/*!
	f[^̍폜
*/
void CWorkspaceAccess::DeleteKey(CUTF8String key)
{
	ASSERT(m_root != NULL);

	m_root->DeleteKey(m_path + key);
}


/////////////////////////////////////////////////////////////////////////////
//	Tum[hɊւ鏈
/////////////////////////////////////////////////////////////////////////////
/*!
	m[h폜
*/
void CWorkspaceAccess::DeleteNode(CUTF8String name)
{
	ASSERT(m_root != NULL);

	m_root->DeleteNode(m_path + name);
}


/*!
	Tum[h𓾂
*/
int CWorkspaceAccess::GetSubNodeCount()
{
	ASSERT(m_root != NULL);

	return(m_root->GetSubNodeCount(m_path));
}


/*!
	SẴTum[h𕶎ƂĎ擾
*/
int CWorkspaceAccess::GetAllSubNode(CUTF8StringArray &list)
{
	ASSERT(m_root != NULL);

	CIStringArrayWrap	iList(list);
	return(m_root->GetAllSubNode(m_path, &iList));
}


