#pragma once
#include "types/UTF8Types.h"
#include "WorkspaceString.h"
#include "SimpleArrayTemplate.h"

#define	PAIR_STRING_KEY_LEN			128
#define	PAIR_STRING_DATA_LEN		256
#define	PAIR_STRING_ARRAY_GROW_SIZE	5




/*!
	[NXy[XpL^̈
*/
class CWorkspaceKeyPair
{
public:
	CWorkspaceKeyPair() {};
	CWorkspaceKeyPair(LPCU8STR key,LPCU8STR data)
	{
		m_key = key;
		m_data = data;
	};

	//!	ݒ
	void SetPair(LPCU8STR key, LPCU8STR data)
	{
		m_key = key;
		m_data = data;
	}

	//!	L[擾
	LPCU8STR GetKey()
	{
		return	m_key;
	}

	//!	f[^擾
	LPCU8STR GetData()
	{
		return	m_data;
	}

private:
	//!	L[
	CWorkspaceString<PAIR_STRING_KEY_LEN>	m_key;

	//!	f[^
	CWorkspaceString<PAIR_STRING_DATA_LEN>	m_data;
};




/*!
	\class CWorkspaceKeyPairArray
	\brief L[f[^zNX
*/
class CWorkspaceKeyPairArray : public CSimpleArrayTemplate<CWorkspaceKeyPair,
										CWorkspaceKeyPair&, 
										CSimpleArrayTemplateItmeConstructor<CWorkspaceKeyPair>,
										PAIR_STRING_ARRAY_GROW_SIZE>
{
public:
	///////////////////////////////////////////////////////////////////////////////////
	//	L[yA
	///////////////////////////////////////////////////////////////////////////////////
	//!	ǉ
	void AddNoCompare(LPCU8STR key, LPCU8STR data)
	{
		CSimpleArrayTemplate<	CWorkspaceKeyPair, 
								CWorkspaceKeyPair&,
								CSimpleArrayTemplateItmeConstructor<CWorkspaceKeyPair>,
								PAIR_STRING_ARRAY_GROW_SIZE>
			::Add(CWorkspaceKeyPair(key,data));
	}

	//!	m
	void Add(LPCU8STR key, LPCU8STR data, int noCase = FALSE)
	{
		int index = Find(key, noCase);
		if(index == -1)
			CSimpleArrayTemplate<	CWorkspaceKeyPair, 
									CWorkspaceKeyPair&,
									CSimpleArrayTemplateItmeConstructor<CWorkspaceKeyPair>,
									PAIR_STRING_ARRAY_GROW_SIZE>
				::Add(CWorkspaceKeyPair(key,data));
		else
		{
			GetAt(index).SetPair(key, data);
		}
	}

	//!	擾
	LPCU8STR Get(LPCU8STR key, LPCU8STR defVal, int noCase = FALSE)
	{
		int index = Find(key, noCase);
		if(index == -1)
			return(defVal);
		else
			return(GetAt(index).GetData());
	}

	//!	폜
	void Delete(LPCU8STR key, int noCase = FALSE)
	{
		int index = Find(key, noCase);
		if(index != -1)
			RemoveAt(index);
	}

	//!	
	int Find(LPCU8STR key, int noCase = FALSE)
	{
		if(noCase)
		{
			for(int i=0;i<GetCount();i++)
				if(_strcmpi((LPCSTR)GetAt(i).GetKey(), (LPCSTR)key) == 0)
					return(i);
			return(-1);
		}
		else
		{
			for(int i=0;i<GetCount();i++)
				if(strcmp((LPCSTR)GetAt(i).GetKey(), (LPCSTR)key) == 0)
					return(i);
			return(-1);
		}
	}

	//!	wʒu擾
	_inline CWorkspaceKeyPair *GetByIndex(int index)
	{
		return(&GetAt(index));
	}

protected:
	///////////////////////////////////////////////////////////////////////////////////
	//	I[o[[h
	///////////////////////////////////////////////////////////////////////////////////
	//!	ubNm
	virtual void *AllocMemoryBlock(int blockSize, int count)
	{
		return new BYTE[blockSize * count];
	}

	//!	ubNJ
	virtual void FreeMemoryBlock(void *memPtr)
	{
		delete (BYTE*)memPtr;
	}
};

