#pragma once
#include "ServerToolWrap.h"
#include "IMimeTypeManager.h"
#include "Settings.h"
#include "SyncObject.h"
#include "SortArray.h"
#include "SimpleManagerInterfaceImplement.h"

class CMimeTypeManager : protected IMimeTypeManager
{
public:
	CMimeTypeManager(void);
	virtual ~CMimeTypeManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();


protected:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	IMimeTypeManager
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	t@CMimeType擾
	virtual void GetMimeTypeByName(IStringPtr mimeType, LPCSTR lpName)
	{
		mimeType->SetString(GetMimeTypeByName(lpName));
	}

	//!	t@CACRpX擾
	virtual void GetIconPathByName(IStringPtr iconPath, LPCSTR lpName)
	{
		iconPath->SetString(GetIconPathByName(lpName));
	}

	///////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	t@CMimeType擾
	CString GetMimeTypeByName(CString name);

	//!	t@CACRpX擾
	CString GetIconPathByName(CString name);

	///////////////////////////////////////////////////////////////////////////////////////////
	//	c[֐
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	MimeType[h
	void LoadMimeType();

	//!	Icon[h
	void LoadIcon();

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection					m_scopeLock;

	//!	tO
	CInterlockCounter					m_init;

	//!	IServerTool
	CIServerToolWrap					m_serverTool;

	//!	C^tF[X
	CSimpleManagerInterfaceImplement	m_managerInterface;

	//!	Mime^Cvݒ
	CMimeTypeManagerSetting				m_mimeTypeSetting;


	//!	MmeTypeƃf[^
	CMapStringToString					m_mimeTypeMap;

	//!	Iconƃf[^
	CKeyDataArray						m_iconArray;
};

